# 南华期货指数行情

**文档ID**: 155
**原始链接**: https://tushare.pro/document/2?doc_id=155

---

## 南华期货指数日线行情

接口：index_daily描述：获取南华指数每日行情，指数行情也可以通过通用行情接口获取数据．权限：用户需要累积2000积分才可以调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>指数代码（南华期货指数以 .NH 结尾，具体请参考本文最下方）</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期 （日期格式：YYYYMMDD，下同）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>None</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>TS指数代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>交易日</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>收盘点位</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>开盘点位</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>最高点位</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>最低点位</td>
</tr>
<tr>
<td>pre_close</td>
<td>float</td>
<td>昨日收盘点</td>
</tr>
<tr>
<td>change</td>
<td>float</td>
<td>涨跌点</td>
</tr>
<tr>
<td>pct_chg</td>
<td>float</td>
<td>涨跌幅</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>成交量（手）</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>成交额（千元）</td>
</tr>
</tbody></table>
接口使用

```

pro = ts.pro_api()

#获取南华沪铜指数
df = pro.index_daily(ts_code='CU.NH', start_date='20180101', end_date='20181201')


```

数据样例

```
    ts_code trade_date     close      open      high       low  pre_close  \
0     CU.NH   20181130  3928.773  3918.501  3928.773  3907.438   3916.130   
1     CU.NH   20181129  3916.130  3891.634  3936.675  3880.572   3894.005   
2     CU.NH   20181128  3894.005  3863.978  3895.585  3841.853   3862.398   
3     CU.NH   20181127  3862.398  3905.068  3906.648  3844.224   3895.585   
4     CU.NH   20181126  3895.585  3895.585  3907.438  3875.831   3903.487   
5     CU.NH   20181123  3903.487  3915.340  3937.465  3897.956   3916.920   
6     CU.NH   20181122  3916.920  3919.291  3927.983  3892.425   3904.277   
7     CU.NH   20181121  3904.277  3931.143  3950.898  3851.335   3917.710   
8     CU.NH   20181120  3917.710  3939.045  3953.268  3914.550   3933.514   
9     CU.NH   20181119  3933.514  3909.018  3944.577  3903.487   3917.710   
10    CU.NH   20181116  3917.710  3916.130  3932.724  3904.277   3912.969   
11    CU.NH   20181115  3912.969  3869.509  3917.710  3865.559   3857.657   
12    CU.NH   20181114  3857.657  3878.992  3899.536  3849.755   3879.782   
13    CU.NH   20181113  3879.782  3866.349  3882.152  3845.804   3865.559   
14    CU.NH   20181112  3865.559  3877.411  3884.523  3853.706   3886.103   
15    CU.NH   20181109  3886.103  3889.264  3916.130  3877.411   3901.117   
16    CU.NH   20181108  3901.117  3921.661  3926.402  3896.376   3909.018 

```

<table>
<thead>
<tr>
<th>指数代码</th>
<th>指数名称</th>
</tr>
</thead>
<tbody><tr>
<td>NHAI.NH</td>
<td>南华农产品指数</td>
</tr>
<tr>
<td>NHCI.NH</td>
<td>南华商品指数</td>
</tr>
<tr>
<td>NHECI.NH</td>
<td>南华能化指数</td>
</tr>
<tr>
<td>NHFI.NH</td>
<td>南华黑色指数</td>
</tr>
<tr>
<td>NHII.NH</td>
<td>南华工业品指数</td>
</tr>
<tr>
<td>NHMI.NH</td>
<td>南华金属指数</td>
</tr>
<tr>
<td>NHNFI.NH</td>
<td>南华有色金属</td>
</tr>
<tr>
<td>NHPMI.NH</td>
<td>南华贵金属指数</td>
</tr>
<tr>
<td>A.NH</td>
<td>南华连大豆指数</td>
</tr>
<tr>
<td>AG.NH</td>
<td>南华沪银指数</td>
</tr>
<tr>
<td>AL.NH</td>
<td>南华沪铝指数</td>
</tr>
<tr>
<td>AP.NH</td>
<td>南华郑苹果指数</td>
</tr>
<tr>
<td>AU.NH</td>
<td>南华沪黄金指数</td>
</tr>
<tr>
<td>BB.NH</td>
<td>南华连胶合板指数</td>
</tr>
<tr>
<td>BU.NH</td>
<td>南华沪石油沥青指数</td>
</tr>
<tr>
<td>C.NH</td>
<td>南华连玉米指数</td>
</tr>
<tr>
<td>CF.NH</td>
<td>南华郑棉花指数</td>
</tr>
<tr>
<td>CS.NH</td>
<td>南华连玉米淀粉指数</td>
</tr>
<tr>
<td>CU.NH</td>
<td>南华沪铜指数</td>
</tr>
<tr>
<td>CY.NH</td>
<td>南华棉纱指数</td>
</tr>
<tr>
<td>ER.NH</td>
<td>南华郑籼稻指数</td>
</tr>
<tr>
<td>FB.NH</td>
<td>南华连纤维板指数</td>
</tr>
<tr>
<td>FG.NH</td>
<td>南华郑玻璃指数</td>
</tr>
<tr>
<td>FU.NH</td>
<td>南华沪燃油指数</td>
</tr>
<tr>
<td>HC.NH</td>
<td>南华沪热轧卷板指数</td>
</tr>
<tr>
<td>I.NH</td>
<td>南华连铁矿石指数</td>
</tr>
<tr>
<td>J.NH</td>
<td>南华连焦炭指数</td>
</tr>
<tr>
<td>JD.NH</td>
<td>南华连鸡蛋指数</td>
</tr>
<tr>
<td>JM.NH</td>
<td>南华连焦煤指数</td>
</tr>
<tr>
<td>JR.NH</td>
<td>南华郑粳稻指数</td>
</tr>
<tr>
<td>L.NH</td>
<td>南华连乙烯指数</td>
</tr>
<tr>
<td>LR.NH</td>
<td>南华郑晚籼稻指数</td>
</tr>
<tr>
<td>M.NH</td>
<td>南华连豆粕指数</td>
</tr>
<tr>
<td>ME.NH</td>
<td>南华郑甲醇指数</td>
</tr>
<tr>
<td>NI.NH</td>
<td>南华沪镍指数</td>
</tr>
<tr>
<td>P.NH</td>
<td>南华连棕油指数</td>
</tr>
<tr>
<td>PB.NH</td>
<td>南华沪铅指数</td>
</tr>
<tr>
<td>PP.NH</td>
<td>南华连聚丙烯指数</td>
</tr>
<tr>
<td>RB.NH</td>
<td>南华沪螺钢指数</td>
</tr>
<tr>
<td>RM.NH</td>
<td>南华郑菜籽粕指数</td>
</tr>
<tr>
<td>RO.NH</td>
<td>南华郑菜油指数</td>
</tr>
<tr>
<td>RS.NH</td>
<td>南华郑油菜籽指数</td>
</tr>
<tr>
<td>RU.NH</td>
<td>南华沪天胶指数</td>
</tr>
<tr>
<td>SC.NH</td>
<td>南华原油指数</td>
</tr>
<tr>
<td>SF.NH</td>
<td>南华郑硅铁指数</td>
</tr>
<tr>
<td>SM.NH</td>
<td>南华郑锰硅指数</td>
</tr>
<tr>
<td>SN.NH</td>
<td>南华沪锡指数</td>
</tr>
<tr>
<td>SP.NH</td>
<td>南华纸浆指数</td>
</tr>
<tr>
<td>SR.NH</td>
<td>南华郑白糖指数</td>
</tr>
<tr>
<td>TA.NH</td>
<td>南华郑精对苯二甲酸指数</td>
</tr>
<tr>
<td>TC.NH</td>
<td>南华郑动力煤指数</td>
</tr>
<tr>
<td>V.NH</td>
<td>南华连聚氯乙烯指数</td>
</tr>
<tr>
<td>WR.NH</td>
<td>南华沪线材指数</td>
</tr>
<tr>
<td>WS.NH</td>
<td>南华郑强麦指数</td>
</tr>
<tr>
<td>Y.NH</td>
<td>南华连豆油指数</td>
</tr>
<tr>
<td>ZN.NH</td>
<td>南华沪锌指数</td>
</tr>
</tbody></table>