# 前十大股东

**文档ID**: 61
**原始链接**: https://tushare.pro/document/2?doc_id=61

---

## 前十大股东

接口：top10_holders描述：获取上市公司前十大股东数据，包括持有数量和比例等信息积分：需2000积分以上才可以调取本接口，5000积分以上频次会更高

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS代码</td>
</tr>
<tr>
<td>period</td>
<td>str</td>
<td>N</td>
<td>报告期（YYYYMMDD格式，一般为每个季度最后一天）</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>N</td>
<td>公告日期</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>报告期开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>报告期结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>TS股票代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>公告日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>报告期</td>
</tr>
<tr>
<td>holder_name</td>
<td>str</td>
<td>股东名称</td>
</tr>
<tr>
<td>hold_amount</td>
<td>float</td>
<td>持有数量（股）</td>
</tr>
<tr>
<td>hold_ratio</td>
<td>float</td>
<td>占总股本比例(%)</td>
</tr>
<tr>
<td>hold_float_ratio</td>
<td>float</td>
<td>占流通股本比例(%)</td>
</tr>
<tr>
<td>hold_change</td>
<td>float</td>
<td>持股变动</td>
</tr>
<tr>
<td>holder_type</td>
<td>str</td>
<td>股东类型</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

df = pro.top10_holders(ts_code='600000.SH', start_date='20170101', end_date='20171231')

```

或者

```

df = pro.query('top10_holders', ts_code='600000.SH', start_date='20170101', end_date='20171231')

```

数据样例

```
     ts_code  ann_date  end_date                        holder_name   hold_amount  hold_ratio
0  600000.SH  20180428  20171231   富德生命人寿保险股份有限公司-传统  2.779437e+09        9.47
1  600000.SH  20180428  20171231        上海国鑫投资发展有限公司  9.455690e+08        3.22
2  600000.SH  20180428  20171231  富德生命人寿保险股份有限公司-万能H  1.270429e+09        4.33
3  600000.SH  20180428  20171231  富德生命人寿保险股份有限公司-资本金  1.763232e+09        6.01
4  600000.SH  20180428  20171231          上海国际集团有限公司  6.331323e+09       21.57
5  600000.SH  20180428  20171231      中国移动通信集团广东有限公司  5.334893e+09       18.18
6  600000.SH  20180428  20171231        中国证券金融股份有限公司  1.216979e+09        4.15
7  600000.SH  20180428  20171231       梧桐树投资平台有限责任公司  8.861313e+08        3.02
8  600000.SH  20180428  20171231      中央汇金资产管理有限责任公司  3.985214e+08        1.36
9  600000.SH  20180428  20171231       上海上国投资产管理有限公司  1.395571e+09        4.75

```
