# 券商盈利预测数据

**文档ID**: 292
**原始链接**: https://tushare.pro/document/2?doc_id=292

---

## 卖方盈利预测数据

接口：report_rc描述：获取券商（卖方）每天研报的盈利预测数据，数据从2010年开始，每晚19~22点更新当日数据限量：单次最大3000条，可分页和循环提取所有数据权限：本接口120积分可以试用，每天10次请求，正式权限需8000积分，每天可请求100000次，10000积分以上无总量限制。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
<tr>
<td>report_date</td>
<td>str</td>
<td>N</td>
<td>报告日期</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>报告开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>报告结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>股票名称</td>
</tr>
<tr>
<td>report_date</td>
<td>str</td>
<td>Y</td>
<td>研报日期</td>
</tr>
<tr>
<td>report_title</td>
<td>str</td>
<td>Y</td>
<td>报告标题</td>
</tr>
<tr>
<td>report_type</td>
<td>str</td>
<td>Y</td>
<td>报告类型</td>
</tr>
<tr>
<td>classify</td>
<td>str</td>
<td>Y</td>
<td>报告分类</td>
</tr>
<tr>
<td>org_name</td>
<td>str</td>
<td>Y</td>
<td>机构名称</td>
</tr>
<tr>
<td>author_name</td>
<td>str</td>
<td>Y</td>
<td>作者</td>
</tr>
<tr>
<td>quarter</td>
<td>str</td>
<td>Y</td>
<td>预测报告期</td>
</tr>
<tr>
<td>op_rt</td>
<td>float</td>
<td>Y</td>
<td>预测营业收入（万元）</td>
</tr>
<tr>
<td>op_pr</td>
<td>float</td>
<td>Y</td>
<td>预测营业利润（万元）</td>
</tr>
<tr>
<td>tp</td>
<td>float</td>
<td>Y</td>
<td>预测利润总额（万元）</td>
</tr>
<tr>
<td>np</td>
<td>float</td>
<td>Y</td>
<td>预测净利润（万元）</td>
</tr>
<tr>
<td>eps</td>
<td>float</td>
<td>Y</td>
<td>预测每股收益（元）</td>
</tr>
<tr>
<td>pe</td>
<td>float</td>
<td>Y</td>
<td>预测市盈率</td>
</tr>
<tr>
<td>rd</td>
<td>float</td>
<td>Y</td>
<td>预测股息率</td>
</tr>
<tr>
<td>roe</td>
<td>float</td>
<td>Y</td>
<td>预测净资产收益率</td>
</tr>
<tr>
<td>ev_ebitda</td>
<td>float</td>
<td>Y</td>
<td>预测EV/EBITDA</td>
</tr>
<tr>
<td>rating</td>
<td>str</td>
<td>Y</td>
<td>卖方评级</td>
</tr>
<tr>
<td>max_price</td>
<td>float</td>
<td>Y</td>
<td>预测最高目标价</td>
</tr>
<tr>
<td>min_price</td>
<td>float</td>
<td>Y</td>
<td>预测最低目标价</td>
</tr>
<tr>
<td>imp_dg</td>
<td>str</td>
<td>N</td>
<td>机构关注度</td>
</tr>
<tr>
<td>create_time</td>
<td>datetime</td>
<td>N</td>
<td>TS数据更新时间</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

df = pro.report_rc(ts_code='', report_date='20220429')

```

数据样例

```
    ts_code        name      report_date   classify   org_name quarter     eps       pe
0     000733.SZ  振华科技    20220429     一般报告     安信证券  2024Q4  6.7800  14.2000
1     000858.SZ   五粮液    20220429     一般报告     华西证券  2022Q4  6.9800  23.7700
2     000858.SZ   五粮液    20220429     一般报告     华西证券  2023Q4  8.2200  20.1800
3     000858.SZ   五粮液    20220429     一般报告     华西证券  2024Q4  9.5800  17.3100
4     000858.SZ   五粮液    20220429     一般报告     信达证券  2022Q4  7.1100  23.3100
...         ...   ...         ...      ...      ...     ...     ...      ...
2552  688385.SH  复旦微电    20220429     一般报告     方正证券  2022Q4  0.9100  62.7000
2553  688385.SH  复旦微电    20220429     一般报告     方正证券  2023Q4  1.1600  49.1900
2554  688385.SH  复旦微电    20220429     一般报告     方正证券  2024Q4  1.5800  36.3200
2555  000733.SZ  振华科技    20220429     一般报告     安信证券  2022Q4  4.3000  22.4000
2556  000733.SZ  振华科技    20220429     一般报告     安信证券  2023Q4  5.4100  17.8000

```
