# 利润表

**文档ID**: 33
**原始链接**: https://tushare.pro/document/2?doc_id=33

---

## 利润表

接口：income，可以通过数据工具调试和查看数据。描述：获取上市公司财务利润表数据积分：用户需要至少2000积分才可以调取，具体请参阅积分获取办法提示：当前接口只能按单只股票获取其历史数据，如果需要获取某一季度全部上市公司数据，请使用income_vip接口（参数一致），需积攒5000积分。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>N</td>
<td>公告日期（YYYYMMDD格式，下同）</td>
</tr>
<tr>
<td>f_ann_date</td>
<td>str</td>
<td>N</td>
<td>实际公告日期</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>公告开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>公告结束日期</td>
</tr>
<tr>
<td>period</td>
<td>str</td>
<td>N</td>
<td>报告期(每个季度最后一天的日期，比如20171231表示年报，20170630半年报，20170930三季报)</td>
</tr>
<tr>
<td>report_type</td>
<td>str</td>
<td>N</td>
<td>报告类型，参考文档最下方说明</td>
</tr>
<tr>
<td>comp_type</td>
<td>str</td>
<td>N</td>
<td>公司类型（1一般工商业2银行3保险4证券）</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>Y</td>
<td>公告日期</td>
</tr>
<tr>
<td>f_ann_date</td>
<td>str</td>
<td>Y</td>
<td>实际公告日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>Y</td>
<td>报告期</td>
</tr>
<tr>
<td>report_type</td>
<td>str</td>
<td>Y</td>
<td>报告类型 见底部表</td>
</tr>
<tr>
<td>comp_type</td>
<td>str</td>
<td>Y</td>
<td>公司类型(1一般工商业2银行3保险4证券)</td>
</tr>
<tr>
<td>end_type</td>
<td>str</td>
<td>Y</td>
<td>报告期类型</td>
</tr>
<tr>
<td>basic_eps</td>
<td>float</td>
<td>Y</td>
<td>基本每股收益</td>
</tr>
<tr>
<td>diluted_eps</td>
<td>float</td>
<td>Y</td>
<td>稀释每股收益</td>
</tr>
<tr>
<td>total_revenue</td>
<td>float</td>
<td>Y</td>
<td>营业总收入</td>
</tr>
<tr>
<td>revenue</td>
<td>float</td>
<td>Y</td>
<td>营业收入</td>
</tr>
<tr>
<td>int_income</td>
<td>float</td>
<td>Y</td>
<td>利息收入</td>
</tr>
<tr>
<td>prem_earned</td>
<td>float</td>
<td>Y</td>
<td>已赚保费</td>
</tr>
<tr>
<td>comm_income</td>
<td>float</td>
<td>Y</td>
<td>手续费及佣金收入</td>
</tr>
<tr>
<td>n_commis_income</td>
<td>float</td>
<td>Y</td>
<td>手续费及佣金净收入</td>
</tr>
<tr>
<td>n_oth_income</td>
<td>float</td>
<td>Y</td>
<td>其他经营净收益</td>
</tr>
<tr>
<td>n_oth_b_income</td>
<td>float</td>
<td>Y</td>
<td>加:其他业务净收益</td>
</tr>
<tr>
<td>prem_income</td>
<td>float</td>
<td>Y</td>
<td>保险业务收入</td>
</tr>
<tr>
<td>out_prem</td>
<td>float</td>
<td>Y</td>
<td>减:分出保费</td>
</tr>
<tr>
<td>une_prem_reser</td>
<td>float</td>
<td>Y</td>
<td>提取未到期责任准备金</td>
</tr>
<tr>
<td>reins_income</td>
<td>float</td>
<td>Y</td>
<td>其中:分保费收入</td>
</tr>
<tr>
<td>n_sec_tb_income</td>
<td>float</td>
<td>Y</td>
<td>代理买卖证券业务净收入</td>
</tr>
<tr>
<td>n_sec_uw_income</td>
<td>float</td>
<td>Y</td>
<td>证券承销业务净收入</td>
</tr>
<tr>
<td>n_asset_mg_income</td>
<td>float</td>
<td>Y</td>
<td>受托客户资产管理业务净收入</td>
</tr>
<tr>
<td>oth_b_income</td>
<td>float</td>
<td>Y</td>
<td>其他业务收入</td>
</tr>
<tr>
<td>fv_value_chg_gain</td>
<td>float</td>
<td>Y</td>
<td>加:公允价值变动净收益</td>
</tr>
<tr>
<td>invest_income</td>
<td>float</td>
<td>Y</td>
<td>加:投资净收益</td>
</tr>
<tr>
<td>ass_invest_income</td>
<td>float</td>
<td>Y</td>
<td>其中:对联营企业和合营企业的投资收益</td>
</tr>
<tr>
<td>forex_gain</td>
<td>float</td>
<td>Y</td>
<td>加:汇兑净收益</td>
</tr>
<tr>
<td>total_cogs</td>
<td>float</td>
<td>Y</td>
<td>营业总成本</td>
</tr>
<tr>
<td>oper_cost</td>
<td>float</td>
<td>Y</td>
<td>减:营业成本</td>
</tr>
<tr>
<td>int_exp</td>
<td>float</td>
<td>Y</td>
<td>减:利息支出</td>
</tr>
<tr>
<td>comm_exp</td>
<td>float</td>
<td>Y</td>
<td>减:手续费及佣金支出</td>
</tr>
<tr>
<td>biz_tax_surchg</td>
<td>float</td>
<td>Y</td>
<td>减:营业税金及附加</td>
</tr>
<tr>
<td>sell_exp</td>
<td>float</td>
<td>Y</td>
<td>减:销售费用</td>
</tr>
<tr>
<td>admin_exp</td>
<td>float</td>
<td>Y</td>
<td>减:管理费用</td>
</tr>
<tr>
<td>fin_exp</td>
<td>float</td>
<td>Y</td>
<td>减:财务费用</td>
</tr>
<tr>
<td>assets_impair_loss</td>
<td>float</td>
<td>Y</td>
<td>减:资产减值损失</td>
</tr>
<tr>
<td>prem_refund</td>
<td>float</td>
<td>Y</td>
<td>退保金</td>
</tr>
<tr>
<td>compens_payout</td>
<td>float</td>
<td>Y</td>
<td>赔付总支出</td>
</tr>
<tr>
<td>reser_insur_liab</td>
<td>float</td>
<td>Y</td>
<td>提取保险责任准备金</td>
</tr>
<tr>
<td>div_payt</td>
<td>float</td>
<td>Y</td>
<td>保户红利支出</td>
</tr>
<tr>
<td>reins_exp</td>
<td>float</td>
<td>Y</td>
<td>分保费用</td>
</tr>
<tr>
<td>oper_exp</td>
<td>float</td>
<td>Y</td>
<td>营业支出</td>
</tr>
<tr>
<td>compens_payout_refu</td>
<td>float</td>
<td>Y</td>
<td>减:摊回赔付支出</td>
</tr>
<tr>
<td>insur_reser_refu</td>
<td>float</td>
<td>Y</td>
<td>减:摊回保险责任准备金</td>
</tr>
<tr>
<td>reins_cost_refund</td>
<td>float</td>
<td>Y</td>
<td>减:摊回分保费用</td>
</tr>
<tr>
<td>other_bus_cost</td>
<td>float</td>
<td>Y</td>
<td>其他业务成本</td>
</tr>
<tr>
<td>operate_profit</td>
<td>float</td>
<td>Y</td>
<td>营业利润</td>
</tr>
<tr>
<td>non_oper_income</td>
<td>float</td>
<td>Y</td>
<td>加:营业外收入</td>
</tr>
<tr>
<td>non_oper_exp</td>
<td>float</td>
<td>Y</td>
<td>减:营业外支出</td>
</tr>
<tr>
<td>nca_disploss</td>
<td>float</td>
<td>Y</td>
<td>其中:减:非流动资产处置净损失</td>
</tr>
<tr>
<td>total_profit</td>
<td>float</td>
<td>Y</td>
<td>利润总额</td>
</tr>
<tr>
<td>income_tax</td>
<td>float</td>
<td>Y</td>
<td>所得税费用</td>
</tr>
<tr>
<td>n_income</td>
<td>float</td>
<td>Y</td>
<td>净利润(含少数股东损益)</td>
</tr>
<tr>
<td>n_income_attr_p</td>
<td>float</td>
<td>Y</td>
<td>净利润(不含少数股东损益)</td>
</tr>
<tr>
<td>minority_gain</td>
<td>float</td>
<td>Y</td>
<td>少数股东损益</td>
</tr>
<tr>
<td>oth_compr_income</td>
<td>float</td>
<td>Y</td>
<td>其他综合收益</td>
</tr>
<tr>
<td>t_compr_income</td>
<td>float</td>
<td>Y</td>
<td>综合收益总额</td>
</tr>
<tr>
<td>compr_inc_attr_p</td>
<td>float</td>
<td>Y</td>
<td>归属于母公司(或股东)的综合收益总额</td>
</tr>
<tr>
<td>compr_inc_attr_m_s</td>
<td>float</td>
<td>Y</td>
<td>归属于少数股东的综合收益总额</td>
</tr>
<tr>
<td>ebit</td>
<td>float</td>
<td>Y</td>
<td>息税前利润</td>
</tr>
<tr>
<td>ebitda</td>
<td>float</td>
<td>Y</td>
<td>息税折旧摊销前利润</td>
</tr>
<tr>
<td>insurance_exp</td>
<td>float</td>
<td>Y</td>
<td>保险业务支出</td>
</tr>
<tr>
<td>undist_profit</td>
<td>float</td>
<td>Y</td>
<td>年初未分配利润</td>
</tr>
<tr>
<td>distable_profit</td>
<td>float</td>
<td>Y</td>
<td>可分配利润</td>
</tr>
<tr>
<td>rd_exp</td>
<td>float</td>
<td>Y</td>
<td>研发费用</td>
</tr>
<tr>
<td>fin_exp_int_exp</td>
<td>float</td>
<td>Y</td>
<td>财务费用:利息费用</td>
</tr>
<tr>
<td>fin_exp_int_inc</td>
<td>float</td>
<td>Y</td>
<td>财务费用:利息收入</td>
</tr>
<tr>
<td>transfer_surplus_rese</td>
<td>float</td>
<td>Y</td>
<td>盈余公积转入</td>
</tr>
<tr>
<td>transfer_housing_imprest</td>
<td>float</td>
<td>Y</td>
<td>住房周转金转入</td>
</tr>
<tr>
<td>transfer_oth</td>
<td>float</td>
<td>Y</td>
<td>其他转入</td>
</tr>
<tr>
<td>adj_lossgain</td>
<td>float</td>
<td>Y</td>
<td>调整以前年度损益</td>
</tr>
<tr>
<td>withdra_legal_surplus</td>
<td>float</td>
<td>Y</td>
<td>提取法定盈余公积</td>
</tr>
<tr>
<td>withdra_legal_pubfund</td>
<td>float</td>
<td>Y</td>
<td>提取法定公益金</td>
</tr>
<tr>
<td>withdra_biz_devfund</td>
<td>float</td>
<td>Y</td>
<td>提取企业发展基金</td>
</tr>
<tr>
<td>withdra_rese_fund</td>
<td>float</td>
<td>Y</td>
<td>提取储备基金</td>
</tr>
<tr>
<td>withdra_oth_ersu</td>
<td>float</td>
<td>Y</td>
<td>提取任意盈余公积金</td>
</tr>
<tr>
<td>workers_welfare</td>
<td>float</td>
<td>Y</td>
<td>职工奖金福利</td>
</tr>
<tr>
<td>distr_profit_shrhder</td>
<td>float</td>
<td>Y</td>
<td>可供股东分配的利润</td>
</tr>
<tr>
<td>prfshare_payable_dvd</td>
<td>float</td>
<td>Y</td>
<td>应付优先股股利</td>
</tr>
<tr>
<td>comshare_payable_dvd</td>
<td>float</td>
<td>Y</td>
<td>应付普通股股利</td>
</tr>
<tr>
<td>capit_comstock_div</td>
<td>float</td>
<td>Y</td>
<td>转作股本的普通股股利</td>
</tr>
<tr>
<td>net_after_nr_lp_correct</td>
<td>float</td>
<td>N</td>
<td>扣除非经常性损益后的净利润（更正前）</td>
</tr>
<tr>
<td>credit_impa_loss</td>
<td>float</td>
<td>N</td>
<td>信用减值损失</td>
</tr>
<tr>
<td>net_expo_hedging_benefits</td>
<td>float</td>
<td>N</td>
<td>净敞口套期收益</td>
</tr>
<tr>
<td>oth_impair_loss_assets</td>
<td>float</td>
<td>N</td>
<td>其他资产减值损失</td>
</tr>
<tr>
<td>total_opcost</td>
<td>float</td>
<td>N</td>
<td>营业总成本（二）</td>
</tr>
<tr>
<td>amodcost_fin_assets</td>
<td>float</td>
<td>N</td>
<td>以摊余成本计量的金融资产终止确认收益</td>
</tr>
<tr>
<td>oth_income</td>
<td>float</td>
<td>N</td>
<td>其他收益</td>
</tr>
<tr>
<td>asset_disp_income</td>
<td>float</td>
<td>N</td>
<td>资产处置收益</td>
</tr>
<tr>
<td>continued_net_profit</td>
<td>float</td>
<td>N</td>
<td>持续经营净利润</td>
</tr>
<tr>
<td>end_net_profit</td>
<td>float</td>
<td>N</td>
<td>终止经营净利润</td>
</tr>
<tr>
<td>update_flag</td>
<td>str</td>
<td>Y</td>
<td>更新标识</td>
</tr>
</tbody></table>
接口使用说明

```

pro = ts.pro_api()

df = pro.income(ts_code='600000.SH', start_date='20180101', end_date='20180730', fields='ts_code,ann_date,f_ann_date,end_date,report_type,comp_type,basic_eps,diluted_eps')

```

获取某一季度全部股票数据

```

df = pro.income_vip(period='20181231',fields='ts_code,ann_date,f_ann_date,end_date,report_type,comp_type,basic_eps,diluted_eps')

```

数据样例

```
     ts_code  ann_date f_ann_date  end_date report_type comp_type  basic_eps  diluted_eps  \
0  600000.SH  20180428   20180428  20180331           1         2       0.46         0.46   
1  600000.SH  20180428   20180428  20180331           1         2       0.46         0.46   
2  600000.SH  20180428   20180428  20171231           1         2       1.84         1.84
    
    
    

```

主要报表类型说明

<table>
<thead>
<tr>
<th>代码</th>
<th>类型</th>
<th>说明</th>
</tr>
</thead>
<tbody><tr>
<td>1</td>
<td>合并报表</td>
<td>上市公司最新报表（默认）</td>
</tr>
<tr>
<td>2</td>
<td>单季合并</td>
<td>单一季度的合并报表</td>
</tr>
<tr>
<td>3</td>
<td>调整单季合并表</td>
<td>调整后的单季合并报表（如果有）</td>
</tr>
<tr>
<td>4</td>
<td>调整合并报表</td>
<td>本年度公布上年同期的财务报表数据，报告期为上年度</td>
</tr>
<tr>
<td>5</td>
<td>调整前合并报表</td>
<td>数据发生变更，将原数据进行保留，即调整前的原数据</td>
</tr>
<tr>
<td>6</td>
<td>母公司报表</td>
<td>该公司母公司的财务报表数据</td>
</tr>
<tr>
<td>7</td>
<td>母公司单季表</td>
<td>母公司的单季度表</td>
</tr>
<tr>
<td>8</td>
<td>母公司调整单季表</td>
<td>母公司调整后的单季表</td>
</tr>
<tr>
<td>9</td>
<td>母公司调整表</td>
<td>该公司母公司的本年度公布上年同期的财务报表数据</td>
</tr>
<tr>
<td>10</td>
<td>母公司调整前报表</td>
<td>母公司调整之前的原始财务报表数据</td>
</tr>
<tr>
<td>11</td>
<td>母公司调整前合并报表</td>
<td>母公司调整之前合并报表原数据</td>
</tr>
<tr>
<td>12</td>
<td>母公司调整前报表</td>
<td>母公司报表发生变更前保留的原数据</td>
</tr>
</tbody></table>