# 分红送股数据

**文档ID**: 103
**原始链接**: https://tushare.pro/document/2?doc_id=103

---

## 分红送股

接口：dividend描述：分红送股数据权限：用户需要至少2000积分才可以调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>TS代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>N</td>
<td>公告日</td>
</tr>
<tr>
<td>record_date</td>
<td>str</td>
<td>N</td>
<td>股权登记日期</td>
</tr>
<tr>
<td>ex_date</td>
<td>str</td>
<td>N</td>
<td>除权除息日</td>
</tr>
<tr>
<td>imp_ann_date</td>
<td>str</td>
<td>N</td>
<td>实施公告日</td>
</tr>
</tbody></table>
以上参数至少有一个不能为空

输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS代码</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>Y</td>
<td>分红年度</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>Y</td>
<td>预案公告日</td>
</tr>
<tr>
<td>div_proc</td>
<td>str</td>
<td>Y</td>
<td>实施进度</td>
</tr>
<tr>
<td>stk_div</td>
<td>float</td>
<td>Y</td>
<td>每股送转</td>
</tr>
<tr>
<td>stk_bo_rate</td>
<td>float</td>
<td>Y</td>
<td>每股送股比例</td>
</tr>
<tr>
<td>stk_co_rate</td>
<td>float</td>
<td>Y</td>
<td>每股转增比例</td>
</tr>
<tr>
<td>cash_div</td>
<td>float</td>
<td>Y</td>
<td>每股分红（税后）</td>
</tr>
<tr>
<td>cash_div_tax</td>
<td>float</td>
<td>Y</td>
<td>每股分红（税前）</td>
</tr>
<tr>
<td>record_date</td>
<td>str</td>
<td>Y</td>
<td>股权登记日</td>
</tr>
<tr>
<td>ex_date</td>
<td>str</td>
<td>Y</td>
<td>除权除息日</td>
</tr>
<tr>
<td>pay_date</td>
<td>str</td>
<td>Y</td>
<td>派息日</td>
</tr>
<tr>
<td>div_listdate</td>
<td>str</td>
<td>Y</td>
<td>红股上市日</td>
</tr>
<tr>
<td>imp_ann_date</td>
<td>str</td>
<td>Y</td>
<td>实施公告日</td>
</tr>
<tr>
<td>base_date</td>
<td>str</td>
<td>N</td>
<td>基准日</td>
</tr>
<tr>
<td>base_share</td>
<td>float</td>
<td>N</td>
<td>基准股本（万）</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

df = pro.dividend(ts_code='600848.SH', fields='ts_code,div_proc,stk_div,record_date,ex_date')

```

数据样例

```

             ts_code div_proc  stk_div record_date   ex_date
    0  600848.SH       实施     0.10    19950606  19950607
    1  600848.SH       实施     0.10    19970707  19970708
    2  600848.SH       实施     0.15    19960701  19960702
    3  600848.SH       实施     0.10    19980706  19980707
    4  600848.SH       预案     0.00        None      None
    5  600848.SH       实施     0.00    20180522  20180523
    

```
