# 全球财经事件

**文档ID**: 233
**原始链接**: https://tushare.pro/document/2?doc_id=233

---

## 财经日历

接口：eco_cal描述：获取全球财经日历、包括经济事件数据更新限量：单次最大获取100行数据积分：2000积分可调取

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>N</td>
<td>日期（YYYYMMDD格式）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
<tr>
<td>currency</td>
<td>str</td>
<td>N</td>
<td>货币代码</td>
</tr>
<tr>
<td>country</td>
<td>str</td>
<td>N</td>
<td>国家（比如：中国、美国）</td>
</tr>
<tr>
<td>event</td>
<td>str</td>
<td>N</td>
<td>事件 （支持模糊匹配： *非农*）</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>Y</td>
<td>日期</td>
</tr>
<tr>
<td>time</td>
<td>str</td>
<td>Y</td>
<td>时间</td>
</tr>
<tr>
<td>currency</td>
<td>str</td>
<td>Y</td>
<td>货币代码</td>
</tr>
<tr>
<td>country</td>
<td>str</td>
<td>Y</td>
<td>国家</td>
</tr>
<tr>
<td>event</td>
<td>str</td>
<td>Y</td>
<td>经济事件</td>
</tr>
<tr>
<td>value</td>
<td>str</td>
<td>Y</td>
<td>今值</td>
</tr>
<tr>
<td>pre_value</td>
<td>str</td>
<td>Y</td>
<td>前值</td>
</tr>
<tr>
<td>fore_value</td>
<td>str</td>
<td>Y</td>
<td>预测值</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()


#获取指定日期全球经济日历
df = pro.eco_cal(date='20200403')


#获取中国经济事件
df = pro.eco_cal(country='中国')

#获取美国非农数据
df = pro.eco_cal(event='美国季调后非农*', fields='date,time,country,event,value,pre_value,fore_value')

```

数据示例

```
    date      time    country                   event         value pre_value fore_value
0   20200410  09:30      中国      中国PPI年率(%)(年度)(三月)           -0.4%      -1.1%
1   20200410  09:30      中国      中国CPI月率(%)(月度)(三月)            0.8%      -0.7%
2   20200410  09:30      中国      中国CPI年率(%)(年度)(三月)            5.2%       4.9%
3   20200407  15:00      中国              中国外汇储备(美元)          3.107T           
4   20200403  09:45      中国          中国财新服务业PMI(三月)  43.0      26.5           
..       ...    ...     ...                     ...   ...       ...        ...
95  20200229  09:00      中国         中国官方非制造业PMI(二月)  29.6      54.1           
96  20200229  09:00      中国          中国官方制造业PMI(二月)  35.7      50.0       46.0
97  20200229  09:00      中国           中国官方综合PMI(二月)  28.9      53.0           
98  20200308  00:17      中国           中国贸易帐(美元)(二月)          47.21B     12.75B
99  20200308  00:17      中国  中国进口年率-美元计价(%)(年度)(二月)           16.5%      -9.0%
```

美国非农数据：

```
    date       time   country              event                 value pre_value fore_value
0   20200403  20:30      美国  美国季调后非农就业人口变动(三月)  -701K      275K      -100K
1   20200403  20:30      美国  美国季调后非农就业人口变动(三月)             273K      -100K
2   20200403  20:30      美国  美国季调后非农就业人口变动(三月)             273K      -124K
3   20200403  20:30      美国  美国季调后非农就业人口变动(三月)             273K      -100K
4   20200403  20:30      美国  美国季调后非农就业人口变动(三月)             273K      -123K
..       ...    ...     ...                ...    ...       ...        ...
95  20190308  21:30      美国  美国季调后非农就业人口变动(二月)             304K       181K
96  20190308  21:30      美国  美国季调后非农就业人口变动(二月)             304K       180K
97  20190308  21:30      美国  美国季调后非农就业人口变动(二月)             304K       185K
98  20190308  21:30      美国  美国季调后非农就业人口变动(二月)             304K       180K
99  20190308  21:30      美国  美国季调后非农就业人口变动(二月)             304K       185K
```
