# 全国电视剧备案公示数据

**文档ID**: 180
**原始链接**: https://tushare.pro/document/2?doc_id=180

---

## 全国拍摄制作电视剧备案公示数据

接口：teleplay_record描述：获取2009年以来全国拍摄制作电视剧备案公示数据限量：单次最大1000，总量不限制数据权限：用户需要至少积分600才可以调取，积分越多调取频次越高，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>report_date</td>
<td>str</td>
<td>N</td>
<td>备案月份（YYYYMM）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>备案开始月份（YYYYMM）</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>备案结束月份（YYYYMM）</td>
</tr>
<tr>
<td>org</td>
<td>str</td>
<td>N</td>
<td>备案机构</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>N</td>
<td>电视剧名称</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>电视剧名称</td>
</tr>
<tr>
<td>classify</td>
<td>str</td>
<td>Y</td>
<td>题材</td>
</tr>
<tr>
<td>types</td>
<td>str</td>
<td>Y</td>
<td>体裁</td>
</tr>
<tr>
<td>org</td>
<td>str</td>
<td>Y</td>
<td>报备机构</td>
</tr>
<tr>
<td>report_date</td>
<td>str</td>
<td>Y</td>
<td>报备时间</td>
</tr>
<tr>
<td>license_key</td>
<td>str</td>
<td>Y</td>
<td>许可证号</td>
</tr>
<tr>
<td>episodes</td>
<td>str</td>
<td>Y</td>
<td>集数</td>
</tr>
<tr>
<td>shooting_date</td>
<td>str</td>
<td>Y</td>
<td>拍摄时间</td>
</tr>
<tr>
<td>prod_cycle</td>
<td>str</td>
<td>Y</td>
<td>制作周期</td>
</tr>
<tr>
<td>content</td>
<td>str</td>
<td>Y</td>
<td>内容提要</td>
</tr>
<tr>
<td>pro_opi</td>
<td>str</td>
<td>Y</td>
<td>省级管理部门备案意见</td>
</tr>
<tr>
<td>dept_opi</td>
<td>str</td>
<td>Y</td>
<td>相关部门意见</td>
</tr>
<tr>
<td>remarks</td>
<td>str</td>
<td>Y</td>
<td>备注</td>
</tr>
</tbody></table>
接口使用

```
pro = ts.pro_api()

#按备案月份查询
df = pro.teleplay_record(report_date='201905')

df = pro.teleplay_record(start_date='201905', end_date='201906')

#按备案机构查询
df = pro.teleplay_record(org='上海新文化传媒集团股份有限公司')

#按电视剧名称查询
df = pro.teleplay_record(name='三体')
```

数据样例

```
       name classify types                 org report_date  license_key  \
0   新大头儿子和小头爸爸Ⅳ     当代青少    喜剧      怡光国际经济文化集团有限公司      201905       甲第260号   
1          两岸青年     当代都市    一般            九洲音像出版公司      201905       甲第045号   
2          温暖如冰     当代都市    一般        北京雅泽文化发展有限公司      201905   （京）字第7270号   
3        从开始到现在     当代都市    一般         北京好故事影业有限公司      201905  （京）字第13150号   
4      黑咖啡也可以很甜     当代都市    一般          北京版映科技有限公司      201905   （京）字第8580号   
5         社工服务社     当代都市    一般        北京天沐文化传媒有限公司      201905  （京）字第07874号   
6          出水牡丹     当代都市    一般    北京天星亿源影视文化股份有限公司      201905   （京）字第1113号   
7        了不起的女孩     当代都市    一般         北京爱奇艺科技有限公司      201905  （京）字第01938号   
8      年轻的朋友来相会     当代都市    一般      北京主题传奇文化传媒有限公司      201905   （京）字第6101号   
9         京杭大运河     近代革命    一般      北京东方视辉影视传媒有限公司      201905   （京）字第9703号   
10          航天梦     当代其它    一般      北京亿铭方略文化传媒有限公司      201905  （京）字第13069号   
11         裁剪人生     当代都市    一般      北京紫葩国际文化传媒有限公司      201905  （京）字第08683号   
12      爱情是碗油泼面     当代都市    一般          北京版映科技有限公司      201905   （京）字第8580号   
13        流动紫禁城     近代传奇    一般      北京华谊兄弟娱乐投资有限公司      201905   （京）字第2217号   
14           大海     当代都市    一般      北京兄弟映画影视传媒有限公司      201905   （京）字第1805号   
15         浑河之魂     近代革命    一般      北京凌云飞扬文化传媒有限公司      201905   （京）字第3814号   
16         允许回忆     当代都市    一般  昆仑映画影视文化传媒（北京）有限公司      201905   （京）字第2793号   
17         四十而获     当代都市    一般    北京十分乐观影视文化传媒有限公司      201905  （京）字第08259号   
18     像爱人一样拥抱你     当代都市    一般       北京思德睿文化传媒有限公司      201905   （京）字第6317号   


   episodes shooting_date prod_cycle  \
0        50        2019.6        3个月   
1        40        2019.3       10个月   
2        30       2020.12        4个月   
3        45       2019.12       18个月   
4        20        2019.1        3个月   
5        40       2019.11       24个月   
6        46        2019.8       12个月   
7        36        2019.4        5个月   
8        36       2019.11        5个月   
9        51        2019.8        9个月   
10       40        2019.9        6个月   
11       30        2019.8        7个月   
12       20        2019.9        3个月   
13       46        2019.1       12个月   
14       40       2019.12        6个月   
15       45        2019.1       12个月   
16       36        2019.8        3个月   
17       40       2019.12        3个月   
18       40        2020.6       18个月   

                content             pro_opi  \
0   在本部中快乐的大头儿子仍旧过着幸福的生活，温柔贤淑的围裙妈妈、风趣幽默的小头爸爸一如既往地伴...  同意备案，报请总局电视剧管理司公示。   
1   大陆惠台政策的推行，掀起了台湾同胞到大陆求职创业的热潮。顺应热潮，刘欣然等一批台湾青年来到了...  同意备案，报请总局电视剧管理司公示。   
2   九十年代末，因父亲失业，八岁的赵晓臻不得不放弃芭蕾，进入体校。由于自身条件较好，经过几年刻苦...  同意备案，报请总局电视剧管理司公示。   
3   苏白和石普生1985年的同一天出生在北京人民医院。十年后，苏母的突然遇难、苏父因无法承受压力...  同意备案，报请总局电视剧管理司公示。   
4   阳光帅气的杜新尧是一家咖啡店做甜品师，甜美可爱的音乐主播宫海默是这家店的常客。杜新尧被宫海默...  同意备案，报请总局电视剧管理司公示。   
5   广州滨江大学工商管理系的马路在毕业后机缘巧合下来到深圳一家社工组织当社工，通过一年时间马路从...  同意备案，报请总局电视剧管理司公示。   
6   原某市花样游泳队主力队员李丹退役后出任该市花样游泳队的主教练，并把一个叫美美的17岁姑娘带进...  同意备案，报请总局电视剧管理司公示。   
7   陆可和沈思怡是两个性格迥异的女孩却是对方最亲密的朋友。毕业时两人因沈思怡霸道的性格关系破裂，...  同意备案，报请总局电视剧管理司公示。   
8   1980年，来自祖国天南海北的六个年轻人走进同一所大学，成为了同届同学。但就在大学第二年，同...  同意备案，报请总局电视剧管理司公示。   
9   京杭大运河上的北通州，连家船商贩天惠民从嘉兴南湖带商人到枣庄时受伤，回通州以看护燃灯塔为生。...  同意备案，报请总局电视剧管理司公示。   
10  半个世纪以来，以任新华为代表的航天人，他们在中国一穷二白的基础上，经历种种坎坷，克服重重困难...  同意备案，报请总局电视剧管理司公示。   
11  阿朵平静而快乐的生活，被彻底打破了。阿朵得知已过世的自己崇拜喜爱的阿莎姨是自己的生母。对母亲...  同意备案，报请总局电视剧管理司公示。   
12  北漂三年的小米回到了自己的老家西安，并不能很好的适应这里的一切。找了一个多月的工作，高不成低...  同意备案，报请总局电视剧管理司公示。   
13  1932年，日本人逼近平津，珍藏在故宫内的数以百万计的国宝将落入敌手。院长易培基和副院长马衡...  同意备案，报请总局电视剧管理司公示。   
14  大学乐团的小提琴手林曦悦自小学习小提琴，却因为父亲的去世，中断了音乐之路。机缘巧合参与了乐爱...  同意备案，报请总局电视剧管理司公示。   
15  史新幼年时，与义父柳雄及义妹柳月相依为命，后与柳月结为夫妻并双双加入抗日队伍。在一次战斗中，...  同意备案，报请总局电视剧管理司公示。   
16  2005年9月，九中十六班迎来了又一届高一新生，体育特长生江向云，喜欢画漫画的山临青，各科全...  同意备案，报请总局电视剧管理司公示。   
17  四个步入40岁的中年男性在面对生活中的种种压力，深陷中年危机。马丁在健康与事业受到双重打击后...  同意备案，报请总局电视剧管理司公示。   
18  岳柯、任朗、施丞宇是同住在一个屋檐下的室友，三个男人都将面临而立之年的到来，然而一个夜晚打破...  同意备案，报请总局电视剧管理司公示。   
```
