# 债券回购日行情

**文档ID**: 256
**原始链接**: https://tushare.pro/document/2?doc_id=256

---

## 债券回购日行情

接口：repo_daily描述：债券回购日行情限量：单次最大2000条，可多次提取，总量不限制权限：用户需要累积2000积分才可以调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>TS代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期(YYYYMMDD格式，下同)</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>repo_maturity</td>
<td>str</td>
<td>Y</td>
<td>期限品种</td>
</tr>
<tr>
<td>pre_close</td>
<td>float</td>
<td>Y</td>
<td>前收盘(%)</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>开盘价(%)</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>最高价(%)</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>最低价(%)</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘价(%)</td>
</tr>
<tr>
<td>weight</td>
<td>float</td>
<td>Y</td>
<td>加权价(%)</td>
</tr>
<tr>
<td>weight_r</td>
<td>float</td>
<td>Y</td>
<td>加权价(利率债)(%)</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交金额(万元)</td>
</tr>
<tr>
<td>num</td>
<td>int</td>
<td>Y</td>
<td>成交笔数(笔)</td>
</tr>
</tbody></table>
接口使用

```

pro = ts.pro_api()

#获取2020年8月4日债券回购日行情
df = pro.repo_daily(trade_date='20200804')


```

数据样例

```
    ts_code trade_date repo_maturity      weight            amount
0   131800.SZ   20200804         R-003  2.02150000      42783.000000
1   131801.SZ   20200804         R-007  2.23240000     618050.300000
2   131802.SZ   20200804         R-014  2.24820000      59506.300000
3   131803.SZ   20200804         R-028  2.35080000      21210.700000
4   131805.SZ   20200804         R-091  2.35550000       2566.000000
5   131806.SZ   20200804         R-182  2.10840000        113.200000
6   131809.SZ   20200804         R-004  2.06990000      24218.900000
7   131810.SZ   20200804         R-001  2.03600000   10748048.000000
8   131811.SZ   20200804         R-002  2.01270000      39459.200000
9   131981.SZ   20200804        RR-001  6.70000000       1000.000000
10  131982.SZ   20200804        RR-007  6.05000000      22800.000000
11  131983.SZ   20200804        RR-014  5.82000000      18500.000000
12  131985.SZ   20200804         RR-1M  7.00000000       4900.000000
13  204001.SH   20200804         GC001  2.10000000   85393260.000000
14  204002.SH   20200804         GC002  2.09200000     488300.000000
15  204003.SH   20200804         GC003  2.11900000    1260240.000000
16  204004.SH   20200804         GC004  2.16500000     352040.000000
17  204007.SH   20200804         GC007  2.21200000   13110650.000000
18  204014.SH   20200804         GC014  2.25900000    2318820.000000
19  204028.SH   20200804         GC028  2.32100000    1204850.000000
20  204091.SH   20200804         GC091  2.41500000      16330.000000
21  204182.SH   20200804         GC182  2.25800000         80.000000
22  206001.SH   20200804          R001  4.00300000      66518.000000
23  206007.SH   20200804          R007  4.36600000     530473.000000
24  206014.SH   20200804          R014  5.16900000     344245.000000
25  206021.SH   20200804          R021  5.97600000      17976.000000
26  206030.SH   20200804           R1M  5.33200000      56671.000000
27  206090.SH   20200804           R3M  7.59900000       9285.000000
28  207007.SH   20200804        TPR007  2.29900000      37500.000000
29   DR001.IB   20200804         DR001  1.90740000  196463895.000000
30   DR007.IB   20200804         DR007  2.11440000    8751142.000000
31   DR014.IB   20200804         DR014  1.99320000    2810816.000000
32   DR021.IB   20200804         DR021  2.08610000    1800794.000000
33    DR1M.IB   20200804          DR1M  2.02160000     239369.000000
34    DR3M.IB   20200804          DR3M  2.58500000      49956.000000
35    DR6M.IB   20200804          DR6M  2.60000000      10000.000000
36   OR001.IB   20200804         OR001  1.91850000    2677840.000000
37   OR007.IB   20200804         OR007  2.05950000     358750.000000
38   OR014.IB   20200804         OR014  2.41020000     129650.000000
39   OR021.IB   20200804         OR021  1.76630000      42000.000000
40    OR1M.IB   20200804          OR1M  2.36910000      34000.000000
41    R001.IB   20200804          R001  1.96000000  350750823.000000
42    R007.IB   20200804          R007  2.17850000   42502804.000000
43    R014.IB   20200804          R014  2.24390000    8123663.000000
44    R021.IB   20200804          R021  1.97400000    6072093.000000
45     R1M.IB   20200804           R1M  2.44950000    1163185.000000
46     R2M.IB   20200804           R2M  3.91140000      37170.000000
47     R3M.IB   20200804           R3M  2.92950000      88436.000000
48     R4M.IB   20200804           R4M  6.50000000       1750.000000
49     R6M.IB   20200804           R6M  2.60000000      10000.000000
```
