# 仓单日报

**文档ID**: 140
**原始链接**: https://tushare.pro/document/2?doc_id=140

---

## 仓单日报

接口：fut_wsr描述：获取仓单日报数据，了解各仓库/厂库的仓单变化限量：单次最大1000，总量不限制积分：用户需要至少2000积分才可以调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期</td>
</tr>
<tr>
<td>symbol</td>
<td>str</td>
<td>N</td>
<td>产品代码</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期(YYYYMMDD格式，下同)</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
<tr>
<td>exchange</td>
<td>str</td>
<td>N</td>
<td>交易所代码</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>symbol</td>
<td>str</td>
<td>Y</td>
<td>产品代码</td>
</tr>
<tr>
<td>fut_name</td>
<td>str</td>
<td>Y</td>
<td>产品名称</td>
</tr>
<tr>
<td>warehouse</td>
<td>str</td>
<td>Y</td>
<td>仓库名称</td>
</tr>
<tr>
<td>wh_id</td>
<td>str</td>
<td>N</td>
<td>仓库编号</td>
</tr>
<tr>
<td>pre_vol</td>
<td>int</td>
<td>Y</td>
<td>昨日仓单量</td>
</tr>
<tr>
<td>vol</td>
<td>int</td>
<td>Y</td>
<td>今日仓单量</td>
</tr>
<tr>
<td>vol_chg</td>
<td>int</td>
<td>Y</td>
<td>增减量</td>
</tr>
<tr>
<td>area</td>
<td>str</td>
<td>N</td>
<td>地区</td>
</tr>
<tr>
<td>year</td>
<td>str</td>
<td>N</td>
<td>年度</td>
</tr>
<tr>
<td>grade</td>
<td>str</td>
<td>N</td>
<td>等级</td>
</tr>
<tr>
<td>brand</td>
<td>str</td>
<td>N</td>
<td>品牌</td>
</tr>
<tr>
<td>place</td>
<td>str</td>
<td>N</td>
<td>产地</td>
</tr>
<tr>
<td>pd</td>
<td>int</td>
<td>N</td>
<td>升贴水</td>
</tr>
<tr>
<td>is_ct</td>
<td>str</td>
<td>N</td>
<td>是否折算仓单</td>
</tr>
<tr>
<td>unit</td>
<td>str</td>
<td>Y</td>
<td>单位</td>
</tr>
<tr>
<td>exchange</td>
<td>str</td>
<td>N</td>
<td>交易所</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api('your token')

df = pro.fut_wsr(trade_date='20181113', symbol='ZN')

```

数据示例

```
     trade_date symbol fut_name    warehouse  pre_vol   vol  vol_chg unit
0    20181113     ZN        锌      上海裕强     4960  4960        0    吨
1    20181113     ZN        锌      上港物流      702   702        0    吨
2    20181113     ZN        锌    上港物流苏州        0     0        0    吨
3    20181113     ZN        锌      中储吴淞        0     0        0    吨
4    20181113     ZN        锌      中储大场        0     0        0    吨
5    20181113     ZN        锌      中储晟世        0     0        0    吨
6    20181113     ZN        锌      中金圣源      428   353      -75    吨
7    20181113     ZN        锌      全胜物流     2882  2882        0    吨
8    20181113     ZN        锌      南储仓储       25    25        0    吨
9    20181113     ZN        锌      同盛松江        0     0        0    吨
10   20181113     ZN        锌    国储837处        0     0        0    吨
11   20181113     ZN        锌      国储天威        0     0        0    吨
12   20181113     ZN        锌    国能物流常州      200   200        0    吨
13   20181113     ZN        锌   外运华东张华浜        0     0        0    吨
14   20181113     ZN        锌     宁波九龙仓        0     0        0    吨
15   20181113     ZN        锌  广储830三水西        0     0        0    吨
16   20181113     ZN        锌      康运萧山        0     0        0    吨
17   20181113     ZN        锌      无锡国联        0     0        0    吨
18   20181113     ZN        锌      期晟公司      449   226     -223    吨
19   20181113     ZN        锌      浙江康运       25    25        0    吨
20   20181113     ZN        锌     百金汇物流        0     0        0    吨
21   20181113     ZN        锌      裕强闵行        0     0        0    吨

```
