# 交易日历

**文档ID**: 137
**原始链接**: https://tushare.pro/document/2?doc_id=137

---

## 交易日历

接口：trade_cal描述：获取各大期货交易所交易日历数据积分：需2000积分才可以提取数据

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>exchange</td>
<td>str</td>
<td>N</td>
<td>交易所 SHFE 上期所 DCE 大商所 CFFEX中金所  CZCE郑商所 INE上海国际能源交易所</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
<tr>
<td>is_open</td>
<td>int</td>
<td>N</td>
<td>是否交易 0休市 1交易</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>exchange</td>
<td>str</td>
<td>Y</td>
<td>交易所 同参数部分描述</td>
</tr>
<tr>
<td>cal_date</td>
<td>str</td>
<td>Y</td>
<td>日历日期</td>
</tr>
<tr>
<td>is_open</td>
<td>int</td>
<td>Y</td>
<td>是否交易 0休市 1交易</td>
</tr>
<tr>
<td>pretrade_date</td>
<td>str</td>
<td>N</td>
<td>上一个交易日</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api('your token')


df = pro.trade_cal(exchange='DCE', start_date='20180101', end_date='20181231')

```

或者

```

df = pro.query('trade_cal', exchange='DCE', start_date='20180101', end_date='20181231')

```

数据样例

```
        exchange  cal_date  is_open
0        DCE  20180101        0
1        DCE  20180102        1
2        DCE  20180103        1
3        DCE  20180104        1
4        DCE  20180105        1
5        DCE  20180106        0
6        DCE  20180107        0
7        DCE  20180108        1
8        DCE  20180109        1
9        DCE  20180110        1
10       DCE  20180111        1
11       DCE  20180112        1
12       DCE  20180113        0
13       DCE  20180114        0
14       DCE  20180115        1
15       DCE  20180116        1
16       DCE  20180117        1
17       DCE  20180118        1
18       DCE  20180119        1
19       DCE  20180120        0
20       DCE  20180121        0
21       DCE  20180122        1
22       DCE  20180123        1
23       DCE  20180124        1
24       DCE  20180125        1
25       DCE  20180126        1
26       DCE  20180127        0
27       DCE  20180128        0
28       DCE  20180129        1
29       DCE  20180130        1
..       ...       ...      ...
335      DCE  20181202        0
336      DCE  20181203        1
337      DCE  20181204        1
338      DCE  20181205        1
339      DCE  20181206        1
340      DCE  20181207        1
341      DCE  20181208        0
342      DCE  20181209        0
343      DCE  20181210        1
344      DCE  20181211        1
345      DCE  20181212        1
346      DCE  20181213        1
347      DCE  20181214        1
348      DCE  20181215        0
349      DCE  20181216        0
350      DCE  20181217        1
351      DCE  20181218        1
352      DCE  20181219        1
353      DCE  20181220        1
354      DCE  20181221        1
355      DCE  20181222        0
356      DCE  20181223        0
357      DCE  20181224        1
358      DCE  20181225        1
359      DCE  20181226        1
360      DCE  20181227        1
361      DCE  20181228        1
362      DCE  20181229        0
363      DCE  20181230        0
364      DCE  20181231        1

```
