# 中信行业指数日行情

**文档ID**: 308
**原始链接**: https://tushare.pro/document/2?doc_id=308

---

## 中信行业指数行情

接口：ci_daily描述：获取中信行业指数日线行情限量：单次最大4000条，可循环提取积分：5000积分可调取，可通过指数代码和日期参数循环获取所有数据

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>行业代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（YYYYMMDD格式，下同）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>指数代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>开盘点位</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>最低点位</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>最高点位</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘点位</td>
</tr>
<tr>
<td>pre_close</td>
<td>float</td>
<td>Y</td>
<td>昨日收盘点位</td>
</tr>
<tr>
<td>change</td>
<td>float</td>
<td>Y</td>
<td>涨跌点位</td>
</tr>
<tr>
<td>pct_change</td>
<td>float</td>
<td>Y</td>
<td>涨跌幅</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>成交量（万股）</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交额（万元）</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api('your token')

df = pro.ci_daily(trade_date='20230705', fields='ts_code,trade_date,open,low,high,close')

```

数据示例

```
       ts_code   trade_date       open        low       high      close
0    CI005001.CI   20230705  2757.5662  2736.8198  2764.1863  2754.2617
1    CI005002.CI   20230705  3006.7166  3000.1382  3039.3916  3029.7837
2    CI005003.CI   20230705  6443.6250  6431.1250  6597.5933  6588.1401
3    CI005004.CI   20230705  2675.3940  2672.7278  2693.6438  2676.9941
4    CI005005.CI   20230705  1575.1489  1571.6997  1597.4792  1593.6205
..           ...        ...        ...        ...        ...        ...
435  CI005920.CI   20230705  6585.6924  6521.1846  6599.1216  6529.9458
436  CI005921.CI   20230705  2759.9133  2753.9324  2781.3979  2757.9863
437  CI005922.CI   20230705  5690.3843  5645.3955  5690.4165  5652.8184
438  CI005923.CI   20230705  5855.1333  5808.8325  5855.1470  5816.7471
439  CI005924.CI   20230705  5782.8662  5737.0601  5782.8984  5744.5962

[440 rows x 6 columns]

```
