# 中信行业成分

**文档ID**: 373
**原始链接**: https://tushare.pro/document/2?doc_id=373

---

## 中信行业成分

接口：ci_index_member描述：按三级分类提取中信行业成分，可提供某个分类的所有成分，也可按股票代码提取所属分类，参数灵活限量：单次最大5000行，总量不限制权限：用户需5000积分可调取，积分获取方法请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>l1_code</td>
<td>str</td>
<td>N</td>
<td>一级行业代码</td>
</tr>
<tr>
<td>l2_code</td>
<td>str</td>
<td>N</td>
<td>二级行业代码</td>
</tr>
<tr>
<td>l3_code</td>
<td>str</td>
<td>N</td>
<td>三级行业代码</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
<tr>
<td>is_new</td>
<td>str</td>
<td>N</td>
<td>是否最新（默认为“Y是”）</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>l1_code</td>
<td>str</td>
<td>Y</td>
<td>一级行业代码</td>
</tr>
<tr>
<td>l1_name</td>
<td>str</td>
<td>Y</td>
<td>一级行业名称</td>
</tr>
<tr>
<td>l2_code</td>
<td>str</td>
<td>Y</td>
<td>二级行业代码</td>
</tr>
<tr>
<td>l2_name</td>
<td>str</td>
<td>Y</td>
<td>二级行业名称</td>
</tr>
<tr>
<td>l3_code</td>
<td>str</td>
<td>Y</td>
<td>三级行业代码</td>
</tr>
<tr>
<td>l3_name</td>
<td>str</td>
<td>Y</td>
<td>三级行业名称</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>成分股票代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>成分股票名称</td>
</tr>
<tr>
<td>in_date</td>
<td>str</td>
<td>Y</td>
<td>纳入日期</td>
</tr>
<tr>
<td>out_date</td>
<td>str</td>
<td>Y</td>
<td>剔除日期</td>
</tr>
<tr>
<td>is_new</td>
<td>str</td>
<td>Y</td>
<td>是否最新Y是N否</td>
</tr>
</tbody></table>
接口示例

```

#获取二级分类元器件的成份股
df = pro.ci_index_member(l2_code='CI005835.CI', fields='l2_code,l1_name,ts_code,name')

#获取000001.SZ所属行业
df = pro.ci_index_member(ts_code='000001.SZ')

```

数据示例

```
        l2_code     l1_name  ts_code       name
0   CI005835.CI      电子  301628.SZ       强达电路
1   CI005835.CI      电子  920060.BJ        万源通
2   CI005835.CI      电子  301251.SZ        威尔高
3   CI005835.CI      电子  002552.SZ       宝鼎科技
4   CI005835.CI      电子  301566.SZ       达利凯普
5   CI005835.CI      电子  688519.SH       南亚新材
6   CI005835.CI      电子  603920.SH       世运电路
7   CI005835.CI      电子  603936.SH       博敏电子
8   CI005835.CI      电子  603989.SH       艾华集团
9   CI005835.CI      电子  688020.SH       方邦股份
10  CI005835.CI      电子  300852.SZ       四会富仕
11  CI005835.CI      电子  688655.SH        迅捷兴
12  CI005835.CI      电子  688183.SH       生益电子
13  CI005835.CI      电子  301132.SZ       满坤科技
14  CI005835.CI      电子  001389.SZ       广合科技
15  CI005835.CI      电子  002288.SZ  *ST超华(退市)
16  CI005835.CI      电子  600563.SH       法拉电子
17  CI005835.CI      电子  603186.SH       华正新材
18  CI005835.CI      电子  603228.SH       景旺电子
19  CI005835.CI      电子  603328.SH       依顿电子
20  CI005835.CI      电子  000636.SZ       风华高科
21  CI005835.CI      电子  000823.SZ       超声电子
22  CI005835.CI      电子  002134.SZ       天津普林
23  CI005835.CI      电子  002138.SZ       顺络电子
24  CI005835.CI      电子  002199.SZ      *ST东晶
25  CI005835.CI      电子  002436.SZ       兴森科技
26  CI005835.CI      电子  002463.SZ       沪电股份
27  CI005835.CI      电子  002484.SZ       江海股份
28  CI005835.CI      电子  002579.SZ       中京电子
29  CI005835.CI      电子  002618.SZ    丹邦退(退市)
30  CI005835.CI      电子  002636.SZ       金安国纪
31  CI005835.CI      电子  300814.SZ       中富电路
32  CI005835.CI      电子  300964.SZ       本川智能
33  CI005835.CI      电子  002815.SZ       崇达技术
34  CI005835.CI      电子  002859.SZ       洁美科技
35  CI005835.CI      电子  002913.SZ        奥士康
36  CI005835.CI      电子  002916.SZ       深南电路
37  CI005835.CI      电子  301366.SZ       一博科技
38  CI005835.CI      电子  300319.SZ       麦捷科技
39  CI005835.CI      电子  300408.SZ       三环集团
40  CI005835.CI      电子  300476.SZ       胜宏科技
41  CI005835.CI      电子  688630.SH       芯碁微装
42  CI005835.CI      电子  300975.SZ       商络电子
43  CI005835.CI      电子  837821.BJ       则成电子
44  CI005835.CI      电子  871981.BJ       晶赛科技
45  CI005835.CI      电子  300657.SZ       弘信电子
46  CI005835.CI      电子  301282.SZ       金禄电子
47  CI005835.CI      电子  300739.SZ       明阳电路
48  CI005835.CI      电子  600183.SH       生益科技
49  CI005835.CI      电子  600237.SH       铜峰电子
50  CI005835.CI      电子  603386.SH       骏亚科技
51  CI005835.CI      电子  605258.SH       协和电子
52  CI005835.CI      电子  300903.SZ       科翔股份
53  CI005835.CI      电子  605058.SH       澳弘电子
54  CI005835.CI      电子  301041.SZ        金百泽

```
