# 东财概念和行业指数行情

**文档ID**: 382
**原始链接**: https://tushare.pro/document/2?doc_id=382

---

## 东财概念板块行情

接口：dc_daily描述：获取东财概念板块、行业指数板块、地域板块行情数据，历史数据开始于2020年限量：单次最大2000条数据，可根据日期参数循环获取权限：用户积累6000积分可调取，具体请参阅积分获取办法注意：本接口只限个人学习和研究使用，如需商业用途，请自行联系东方财富解决数据采购问题。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>板块代码（格式：xxxxx.DC)</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期(格式：YYYYMMDD下同）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
<tr>
<td>idx_type</td>
<td>str</td>
<td>N</td>
<td>板块类型： 概念板块、行业板块、地域板块</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>板块代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘点位</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>开盘点位</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>最高点位</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>最低点位</td>
</tr>
<tr>
<td>change</td>
<td>float</td>
<td>Y</td>
<td>涨跌点位</td>
</tr>
<tr>
<td>pct_change</td>
<td>float</td>
<td>Y</td>
<td>涨跌幅</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>成交量</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交额</td>
</tr>
<tr>
<td>swing</td>
<td>float</td>
<td>Y</td>
<td>振幅</td>
</tr>
<tr>
<td>turnover_rate</td>
<td>float</td>
<td>Y</td>
<td>换手率</td>
</tr>
</tbody></table>
接口示例

```

#获取东方财富2025年5月13日概念板块行情
df = pro.dc_daily(trade_date='20250513')


```

数据示例

```
       ts_code trade_date       close        open        high         low pct_change
0    BK1063.DC   20250513    792.5200    793.5200    795.0400    786.9000     0.8700
1    BK1051.DC   20250513  12408.8600  12510.2500  12573.2800  12350.8900     4.3700
2    BK0816.DC   20250513     65.8600     66.6700     67.0200     65.4500     3.7700
3    BK0547.DC   20250513  12810.7600  12745.7200  12823.3500  12691.3900     0.6000
4    BK1082.DC   20250513   1306.9800   1337.2300   1342.8900   1302.9700    -1.3900
..         ...        ...         ...         ...         ...         ...        ...
430  BK0915.DC   20250513   1136.7400   1159.1800   1162.3600   1133.9400    -1.0200
431  BK1084.DC   20250513   1481.1500   1514.2300   1517.7200   1476.3200    -0.6100
432  BK0957.DC   20250513   1277.3800   1295.2900   1303.0000   1275.1900    -0.3500
433  BK1156.DC   20250513   1350.4700   1356.8500   1372.2800   1344.9400     0.0100
434  BK0881.DC   20250513   1156.1600   1181.2600   1184.1800   1154.0800    -0.5700

```
