# 东方财富概念板块

**文档ID**: 362
**原始链接**: https://tushare.pro/document/2?doc_id=362

---

## 东方财富概念板块

接口：dc_index描述：获取东方财富每个交易日的概念板块数据，支持按日期查询限量：单次最大可获取5000条数据，历史数据可根据日期循环获取权限：用户积累6000积分可调取，具体请参阅积分获取办法

注意：本接口只限个人学习和研究使用，如需商业用途，请自行联系东方财富解决数据采购问题。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>指数代码（支持多个代码同时输入，用逗号分隔）</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>N</td>
<td>板块名称（例如：人形机器人）</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（YYYYMMDD格式，下同）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>概念代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>概念名称</td>
</tr>
<tr>
<td>leading</td>
<td>str</td>
<td>Y</td>
<td>领涨股票名称</td>
</tr>
<tr>
<td>leading_code</td>
<td>str</td>
<td>Y</td>
<td>领涨股票代码</td>
</tr>
<tr>
<td>pct_change</td>
<td>float</td>
<td>Y</td>
<td>涨跌幅</td>
</tr>
<tr>
<td>leading_pct</td>
<td>float</td>
<td>Y</td>
<td>领涨股票涨跌幅</td>
</tr>
<tr>
<td>total_mv</td>
<td>float</td>
<td>Y</td>
<td>总市值（万元）</td>
</tr>
<tr>
<td>turnover_rate</td>
<td>float</td>
<td>Y</td>
<td>换手率</td>
</tr>
<tr>
<td>up_num</td>
<td>int</td>
<td>Y</td>
<td>上涨家数</td>
</tr>
<tr>
<td>down_num</td>
<td>int</td>
<td>Y</td>
<td>下降家数</td>
</tr>
</tbody></table>
接口示例

```

#获取东方财富2025年1月3日的概念板块列表
df = pro.dc_index(trade_date='20250103', fields='ts_code,name,turnover_rate,up_num,down_num')


```

数据示例

```
       ts_code   name       turnover_rate  up_num  down_num
0    BK1186.DC   首发经济        8.3700       4        31
1    BK1185.DC   冰雪经济        4.0800       2        32
2    BK1184.DC  人形机器人        4.0800       2        62
3    BK1183.DC   谷子经济        4.6300       2        55
4    BK1182.DC   智谱AI        5.4000       0        33
..         ...    ...           ...     ...       ...
453  BK0498.DC    AB股        1.7300       4        67
454  BK0494.DC   节能环保        2.1600      32       378
455  BK0493.DC    新能源        1.4800      19       184
456  BK0492.DC    煤化工        1.7000      16        56
457  BK0490.DC     军工        2.5200      32       465

```
