# 东方财富概念成分

**文档ID**: 363
**原始链接**: https://tushare.pro/document/2?doc_id=363

---

## 东方财富板块成分

接口：dc_member描述：获取东方财富板块每日成分数据，可以根据概念板块代码和交易日期，获取历史成分限量：单次最大获取5000条数据，可以通过日期和代码循环获取权限：用户积累6000积分可调取，具体请参阅积分获取办法注意：本接口只限个人学习和研究使用，如需商业用途，请自行联系东方财富解决数据采购问题。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>板块指数代码</td>
</tr>
<tr>
<td>con_code</td>
<td>str</td>
<td>N</td>
<td>成分股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（YYYYMMDD格式）</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>概念代码</td>
</tr>
<tr>
<td>con_code</td>
<td>str</td>
<td>Y</td>
<td>成分代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>成分股名称</td>
</tr>
</tbody></table>
接口示例

```

#获取东方财富2025年1月2日的人形机器人概念板块成分列表
df = pro.dc_member(trade_date='20250102', ts_code='BK1184.DC')


```

数据示例

```
     trade_date  ts_code   con_code   name
0    20250102  BK1184.DC  002117.SZ   东港股份
1    20250102  BK1184.DC  603662.SH   柯力传感
2    20250102  BK1184.DC  688165.SH  埃夫特-U
3    20250102  BK1184.DC  300660.SZ   江苏雷利
4    20250102  BK1184.DC  873593.BJ   鼎智科技
..        ...        ...        ...    ...
59   20250102  BK1184.DC  002139.SZ   拓邦股份
60   20250102  BK1184.DC  301236.SZ   软通动力
61   20250102  BK1184.DC  601727.SH   上海电气
62   20250102  BK1184.DC  300432.SZ   富临精工
63   20250102  BK1184.DC  300843.SZ   胜蓝股份

```
