# 业绩预告

**文档ID**: 45
**原始链接**: https://tushare.pro/document/2?doc_id=45

---

## 业绩预告

接口：forecast，可以通过数据工具调试和查看数据。描述：获取业绩预告数据权限：用户需要至少2000积分才可以调取，具体请参阅积分获取办法提示：当前接口只能按单只股票获取其历史数据，如果需要获取某一季度全部上市公司数据，请使用forecast_vip接口（参数一致），需积攒5000积分。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码(二选一)</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>N</td>
<td>公告日期 (二选一)</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>公告开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>公告结束日期</td>
</tr>
<tr>
<td>period</td>
<td>str</td>
<td>N</td>
<td>报告期(每个季度最后一天的日期，比如20171231表示年报，20170630半年报，20170930三季报)</td>
</tr>
<tr>
<td>type</td>
<td>str</td>
<td>N</td>
<td>预告类型(预增/预减/扭亏/首亏/续亏/续盈/略增/略减)</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>TS股票代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>公告日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>报告期</td>
</tr>
<tr>
<td>type</td>
<td>str</td>
<td>业绩预告类型(预增/预减/扭亏/首亏/续亏/续盈/略增/略减)</td>
</tr>
<tr>
<td>p_change_min</td>
<td>float</td>
<td>预告净利润变动幅度下限（%）</td>
</tr>
<tr>
<td>p_change_max</td>
<td>float</td>
<td>预告净利润变动幅度上限（%）</td>
</tr>
<tr>
<td>net_profit_min</td>
<td>float</td>
<td>预告净利润下限（万元）</td>
</tr>
<tr>
<td>net_profit_max</td>
<td>float</td>
<td>预告净利润上限（万元）</td>
</tr>
<tr>
<td>last_parent_net</td>
<td>float</td>
<td>上年同期归属母公司净利润</td>
</tr>
<tr>
<td>first_ann_date</td>
<td>str</td>
<td>首次公告日</td>
</tr>
<tr>
<td>summary</td>
<td>str</td>
<td>业绩预告摘要</td>
</tr>
<tr>
<td>change_reason</td>
<td>str</td>
<td>业绩变动原因</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

pro.forecast(ann_date='20190131', fields='ts_code,ann_date,end_date,type,p_change_min,p_change_max,net_profit_min')

```

获取某一季度全部股票数据

```

df = pro.forecast_vip(period='20181231',fields='ts_code,ann_date,end_date,type,p_change_min,p_change_max,net_profit_min')

```

数据样例

```
       ts_code  ann_date  end_date type  p_change_min  p_change_max  \
0    000005.SZ  20190131  20181231   预增      618.5600      945.1800   
1    000825.SZ  20190131  20181231   略增        3.8500       12.5100   
2    000566.SZ  20190131  20181231   预增       50.0000      100.0000   
3    000932.SZ  20190131  20181231   预增       60.8864       68.1664   
4    000557.SZ  20190131  20181231   预增       66.6800       66.6800   
5    600127.SH  20190131  20181231   首亏     -601.5517     -510.3604   
6    600159.SH  20190131  20181231   预增      315.0000      315.0000   
7    600963.SH  20190131  20181231   略增        2.3800       11.5800   
8    002336.SZ  20190131  20181231   续亏       33.1367       47.9952   
9    601608.SH  20190131  20181231   预增      228.5900      274.5700   
10   600531.SH  20190131  20181231   预减      -61.8800      -54.3200   
11   300200.SZ  20190131  20181231   预增       82.4000      112.4000   
12   300441.SZ  20190131  20181231   略减      -20.5100       -0.6400   
13   300157.SZ  20190131  20181231   扭亏      107.3969      108.5176   
14   300052.SZ  20190131  20181231   略减      -30.0000        0.0000   
15   002328.SZ  20190131  20181231   略增        0.0000       20.0000   
16   300420.SZ  20190131  20181231   预增       61.1500       90.8000   
17   300109.SZ  20190131  20181231   续盈      -13.8100        7.7300   
18   300479.SZ  20190131  20181231   略减      -35.8400       -6.6700   
19   000402.SZ  20190131  20181231   略增        1.0000       10.0000   
20   002626.SZ  20190131  20181231   略增       37.1200       47.6600

```
