# 上证e互动问答

**文档ID**: 366
**原始链接**: https://tushare.pro/document/2?doc_id=366

---

## 上证E互动

接口：irm_qa_sh，历史数据开始于2023年6月。描述：获取上交所e互动董秘问答文本数据。上证e互动是由上海证券交易所建立、上海证券市场所有参与主体无偿使用的沟通平台,旨在引导和促进上市公司、投资者等各市场参与主体之间的信息沟通,构建集中、便捷的互动渠道。本接口数据记录了以上沟通问答的文本数据。限量：单次请求最大返回3000行数据，可根据股票代码，日期等参数循环提取全部数据权限：用户后120积分可以试用，正式权限为10000积分，或申请单独开权限，请参考权限说明

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（格式YYYYMMDD，下同）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
<tr>
<td>pub_date</td>
<td>str</td>
<td>N</td>
<td>发布开始日期(格式：2025-06-03 16:43:03)</td>
</tr>
<tr>
<td>pub_date</td>
<td>str</td>
<td>N</td>
<td>发布结束日期(格式：2025-06-03 18:43:23)</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>公司名称</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>日期</td>
</tr>
<tr>
<td>q</td>
<td>str</td>
<td>Y</td>
<td>问题</td>
</tr>
<tr>
<td>a</td>
<td>str</td>
<td>Y</td>
<td>回复</td>
</tr>
<tr>
<td>pub_time</td>
<td>datetime</td>
<td>Y</td>
<td>回复时间</td>
</tr>
</tbody></table>
接口调用

```

pro = ts.pro_api()

#获取2025年2月12日上证e互动的问答文本
df = pro.irm_qa_sh(ann_date='20250212')

```

数据样例

```
       ts_code  name                                                  q                                                  a
0   601121.SH  宝地矿业  股价利多因素主要看基本面，关键是业绩，利空因素就是减持和低价增发，目前宝地的业绩难以抵消股东...  尊敬的投资者，您好！衷心感谢您对宝地矿业的关注与鞭策。公司将加快推进重点项目建设，做好生产经...
1   600615.SH  丰华股份  您好！我是一名城市居民，长期关注空气污染问题。想请问贵公司在日常经营过程中，是否采取了有效的...  尊敬的投资者您好！公司不属于重点排污单位。公司高度重视环境保护工作，采取有效措施不断提高环境...
2   600615.SH  丰华股份       公司镁合金等材料在机器人行业应用前景远大。公司是不是可以考虑加大在机器人方面的战略布局？  尊敬的投资者您好！镁合金材料在轻量化方面应用领域宽泛，目前公司的镁合金产品主要应用于交通工具...
3   601121.SH  宝地矿业  如果宝地矿业董事会看好自己公司的投资价值，为什么宁可委托申万宏源证券投资理财，也不用自有资金...  尊敬的投资者，您好。感谢您对宝地矿业的关注与建议。公司始终秉持稳健的财务管理和资金使用原则，...
4   600615.SH  丰华股份  尊敬的董秘您好，据报道人形机器人所使用除peek材料之外，最多的就是镁合金相关材质，请问公司...                   尊敬的投资者您好！目前公司没有人形机器人项目储备，感谢您的关注！
..        ...   ...                                                ...                                                ...
95  600423.SH  柳化股份  领导您好！我是一名心系环境的普通居民，长期对空气污染问题保持高度关注。请问贵公司在生产过程中...  投资者，您好！公司十分重视环境问题，积极推动节能减排理念，三废排放严格按照国家标准执行，具体...
96  600190.SH  ST锦港  公司董事会，你公司2024之前问题很大，涉刑事等众多问题，公司必须发布或配合彻查业绩巨亏问题...  尊敬的投资者，您好！公司对相关事项进展将及时履行信息披露义务，请以公司对外披露的公告为准，感...
97  688120.SH  华海清科               你公司在国内行业的竞争优势有哪些？是否将这些优势转化为了公司的发展成果？  尊敬的投资者您好！公司是一家拥有核心自主知识产权的高端半导体装备制造商，产品主要应用于芯片制...
98  688120.SH  华海清科                                   你公司被看好或认可的地方在哪里？  尊敬的投资者您好！公司是一家拥有核心自主知识产权的高端半导体装备制造商，产品主要应用于芯片制...
99  600630.SH  龙头股份                    请问公司接入微信小店已有一段时间，请问微信小店的销售情况如何？  尊敬的投资者，您好！公司旗下三枪品牌目前已入驻微信第三方平台有赞商城。您可在微信小程序搜索“...

```
