# 上海黄金现货日行情

**文档ID**: 285
**原始链接**: https://tushare.pro/document/2?doc_id=285

---

## 现货黄金日行情

接口：sge_daily描述：获取上海黄金交易所现货合约日线行情限量：单次最大2000，可循环或者分页提取积分：用户积2000积分可调取，具体请参阅积分获取办法

注：数据由当日9:00至15:30的交易和前一日夜盘的20:00至2:30数据构成，成交量和成交金额为双向计量。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>合约代码，可通过<a href="https://tushare.pro/document/2?doc_id=284">基础信息</a>获得</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>现货合约代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘点(元/克)</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>开盘点(元/克)</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>最高点(元/克)</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>最低点(元/克)</td>
</tr>
<tr>
<td>price_avg</td>
<td>float</td>
<td>Y</td>
<td>加权平均价(元/克)</td>
</tr>
<tr>
<td>change</td>
<td>float</td>
<td>Y</td>
<td>涨跌点位(元/克)</td>
</tr>
<tr>
<td>pct_change</td>
<td>float</td>
<td>Y</td>
<td>涨跌幅</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>成交量(千克)</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交金额(元)</td>
</tr>
<tr>
<td>oi</td>
<td>float</td>
<td>Y</td>
<td>市场持仓</td>
</tr>
<tr>
<td>settle_vol</td>
<td>float</td>
<td>Y</td>
<td>交收量</td>
</tr>
<tr>
<td>settle_dire</td>
<td>str</td>
<td>Y</td>
<td>持仓方向</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

#获取单日统计数据
df = pro.sge_daily(trade_date='20220311')

#获取某合约指定日期，指定字段输出的数据
df = pro.sge_daily(ts_code='', start_date='20220301', end_date='20220311', fields='ts_code,close,open,vol')


```

数据示例

```
 ts_code trade_date     close      open      high       low         vol     settle_dire
0    Au99.95   20220311  403.3000  403.2000  403.3000  403.2000       24.00        None
1    Au99.99   20220311  403.6000  405.9700  408.0000  402.8000    13667.66        None
2    Au(T+D)   20220311  403.2200  405.0100  407.7000  402.5300    27196.00       空支付给多
3    Pt99.95   20220311  227.0400  228.0000  228.0000  226.3000      384.00        None
4    Ag(T+D)   20220311    5.1340    5.1820    5.1850    5.1090  2428664.00       空支付给多
5     Au100g   20220311  403.0300  405.4500  406.0000  402.3600       29.40        None
6   Au(T+N1)   20220311  405.7000  408.0000  408.0000  402.2000       21.80        None
7   Au(T+N2)   20220311  408.1000  411.0000  414.5000  408.0500       91.20        None
8   mAu(T+D)   20220311  403.4400  406.6200  407.7500  402.7500     4367.80       空支付给多
9   iAu99.99   20220311  405.3400  406.3000  408.0000  405.0000        2.06        None
10    PGC30g   20220311  409.3200  410.0000  410.0000  408.9000        0.36        None
11  NYAuTN06   20220311  404.5500  407.8500  408.8000  404.0000       15.80        None
12  NYAuTN12   20220311  409.0500  413.8500  413.8500  408.9000      214.40        None

```
