# 上海黄金基础信息

**文档ID**: 284
**原始链接**: https://tushare.pro/document/2?doc_id=284

---

## 黄金现货基础信息

接口：sge_basic描述：获取上海黄金交易所现货合约基础信息限量：单次最大100条，当前现货合约数不足20个，可以一次提取全部，不需要循环提取积分：用户积5000积分可以调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>合约代码 （支持多个，逗号分隔，不输入为获取全部）</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>品种代码</td>
</tr>
<tr>
<td>ts_name</td>
<td>str</td>
<td>Y</td>
<td>品种名称</td>
</tr>
<tr>
<td>trade_type</td>
<td>str</td>
<td>Y</td>
<td>交易类型</td>
</tr>
<tr>
<td>t_unit</td>
<td>float</td>
<td>Y</td>
<td>交易单位(克/手)</td>
</tr>
<tr>
<td>p_unit</td>
<td>float</td>
<td>Y</td>
<td>报价单位</td>
</tr>
<tr>
<td>min_change</td>
<td>float</td>
<td>Y</td>
<td>最小变动价位</td>
</tr>
<tr>
<td>price_limit</td>
<td>float</td>
<td>Y</td>
<td>每日价格最大波动限制</td>
</tr>
<tr>
<td>min_vol</td>
<td>int</td>
<td>Y</td>
<td>最小单笔报价量(手)</td>
</tr>
<tr>
<td>max_vol</td>
<td>int</td>
<td>Y</td>
<td>最大单笔报价量(手)</td>
</tr>
<tr>
<td>trade_mode</td>
<td>str</td>
<td>Y</td>
<td>交易期限</td>
</tr>
<tr>
<td>margin_rate</td>
<td>float</td>
<td>Y</td>
<td>保证金比例</td>
</tr>
<tr>
<td>liq_rate</td>
<td>float</td>
<td>Y</td>
<td>违约金比例(%)</td>
</tr>
<tr>
<td>trade_time</td>
<td>str</td>
<td>Y</td>
<td>交易时间</td>
</tr>
<tr>
<td>list_date</td>
<td>str</td>
<td>Y</td>
<td>上市日期</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

df = pro.sge_basic()

```

或者

```

df = pro.sge_basic(ts_code='Au99.95')

```

数据样例

```
  ts_code    ts_name  min_vol  max_vol       trade_time
0    Au99.95     黄金9995        1      500     白天：9:00至15:30，夜间:19:50 至次日 02:30
1    Au99.99     黄金9999        1    50000    白天：9:00至15:30，夜间:19:50 至次日 02:30
2    Au(T+D)       黄金延期        1      200     上午:9:00 至 11:30，下午 ...
3    Pt99.95     铂金9995        1     1000       白天：9:00至15:30，夜间:19:50 至次日 02:30
4    Ag(T+D)       白银延期        1     2000    上午:9:00 至 11:30，下午:...
5     Au100g     100克金条        1     1000     白天：9:00至15:30，夜间:19:50 至次日 02:30
6   Au(T+N1)     黄金T+N1        1     2000      上午:9:00 至 11:30，下午:13:30 至 ...
7   Au(T+N2)     黄金T+N2        1     2000      上午:9:00 至 11:30，下午:13:30 至 ...
8   mAu(T+D)     迷你黄金延期        1     2000    上午:9:00 至 11:30，下午:13:30 至 ...
9   iAu99.99  国际板黄金9999        1    50000    白天：9:00至15:30，夜间:19:50 至次日 02:30
10    PGC30g    熊猫金币30克        1     1000     白天：9:00至15:30，夜间：20:00至次日02:30
11  NYAuTN06  沪纽金AuTN06        1     2000   白天：9:00至15:30，夜间:19:50 至次日 02:30
12  NYAuTN12  沪纽金AuTN12        1     2000   白天：9:00至15:30，夜间:19:50 至次日 02:30

```
