# 上市公司管理层

**文档ID**: 193
**原始链接**: https://tushare.pro/document/2?doc_id=193

---

## 上市公司管理层

接口：stk_managers描述：获取上市公司管理层积分：用户需要2000积分才可以调取，5000积分以上频次相对较高，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码，支持单个或多个股票输入</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>N</td>
<td>公告日期（YYYYMMDD格式，下同）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>公告开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>公告结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS股票代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>Y</td>
<td>公告日期</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>姓名</td>
</tr>
<tr>
<td>gender</td>
<td>str</td>
<td>Y</td>
<td>性别</td>
</tr>
<tr>
<td>lev</td>
<td>str</td>
<td>Y</td>
<td>岗位类别</td>
</tr>
<tr>
<td>title</td>
<td>str</td>
<td>Y</td>
<td>岗位</td>
</tr>
<tr>
<td>edu</td>
<td>str</td>
<td>Y</td>
<td>学历</td>
</tr>
<tr>
<td>national</td>
<td>str</td>
<td>Y</td>
<td>国籍</td>
</tr>
<tr>
<td>birthday</td>
<td>str</td>
<td>Y</td>
<td>出生年月</td>
</tr>
<tr>
<td>begin_date</td>
<td>str</td>
<td>Y</td>
<td>上任日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>Y</td>
<td>离任日期</td>
</tr>
<tr>
<td>resume</td>
<td>str</td>
<td>N</td>
<td>个人简历</td>
</tr>
</tbody></table>
接口用例

```

pro = ts.pro_api()

#获取单个公司高管全部数据
df = pro.stk_managers(ts_code='000001.SZ')

#获取多个公司高管全部数据
df = pro.stk_managers(ts_code='000001.SZ,600000.SH')

```

数据样例

```
    ts_code  ann_date     name    gender  ... national  birthday begin_date  end_date
0    000001.SZ  20190604  姚贵平      M  ...       中国     1961   20180815  20190604
1    000001.SZ  20190604  姚贵平      M  ...       中国     1961   20170629  20190604
2    000001.SZ  20190604  姚贵平      M  ...       中国     1961   20180129  20190604
3    000001.SZ  20190309   吴鹏      M  ...       中国     1965   20110817  20190309
4    000001.SZ  20190307  孙永桢      F  ...       中国     1968   20181025      None
5    000001.SZ  20180816  杨志群      M  ...       中国     1970   20180815      None
6    000001.SZ  20180816  郭世邦      M  ...       中国     1965   20180815      None
7    000001.SZ  20180405  何之江      M  ...       中国     1965   20170513  20180405
8    000001.SZ  20180203  项有志      M  ...       中国     1964   20170913      None
9    000001.SZ  20180130  杨如生      M  ...       中国   196802   20161107      None
10   000001.SZ  20180130  蔡方方      F  ...       中国     1974   20161107      None
11   000001.SZ  20180130  郭田勇      M  ...       中国   196808   20161107      None
12   000001.SZ  20180130   郭建      M  ...       中国     1964   20161107      None
13   000001.SZ  20180130  杨如生      M  ...       中国   196802   20161107      None
14   000001.SZ  20180130  杨如生      M  ...       中国   196802   20161107      None
15   000001.SZ  20180130   姚波      M  ...       中国     1971   20101227      None
16   000001.SZ  20180130  王春汉      M  ...       中国     1951   20160811      None
17   000001.SZ  20180130  郭田勇      M  ...       中国   196808   20160811      None
18   000001.SZ  20180130  郭田勇      M  ...       中国   196808   20160811      None
19   000001.SZ  20180130  韩小京      M  ...       中国     1955   20140121      None
20   000001.SZ  20180130  陈心颖      F  ...      新加坡     1977   20140121      None
21   000001.SZ  20180130  蔡方方      F  ...       中国     1974   20140121      None
22   000001.SZ  20180130  王松奇      M  ...       中国     1952   20140121      None
23   000001.SZ  20180130  王春汉      M  ...       中国     1951   20140121      None
24   000001.SZ  20180130  韩小京      M  ...       中国     1955   20140121      None
```
