# 上市公司基本信息

**文档ID**: 112
**原始链接**: https://tushare.pro/document/2?doc_id=112

---

## 上市公司基本信息

接口：stock_company，可以通过数据工具调试和查看数据。描述：获取上市公司基础信息，单次提取4500条，可以根据交易所分批提取积分：用户需要至少120积分才可以调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必须</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
<tr>
<td>exchange</td>
<td>str</td>
<td>N</td>
<td>交易所代码 ，SSE上交所 SZSE深交所 BSE北交所</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>com_name</td>
<td>str</td>
<td>Y</td>
<td>公司全称</td>
</tr>
<tr>
<td>com_id</td>
<td>str</td>
<td>Y</td>
<td>统一社会信用代码</td>
</tr>
<tr>
<td>exchange</td>
<td>str</td>
<td>Y</td>
<td>交易所代码</td>
</tr>
<tr>
<td>chairman</td>
<td>str</td>
<td>Y</td>
<td>法人代表</td>
</tr>
<tr>
<td>manager</td>
<td>str</td>
<td>Y</td>
<td>总经理</td>
</tr>
<tr>
<td>secretary</td>
<td>str</td>
<td>Y</td>
<td>董秘</td>
</tr>
<tr>
<td>reg_capital</td>
<td>float</td>
<td>Y</td>
<td>注册资本(万元)</td>
</tr>
<tr>
<td>setup_date</td>
<td>str</td>
<td>Y</td>
<td>注册日期</td>
</tr>
<tr>
<td>province</td>
<td>str</td>
<td>Y</td>
<td>所在省份</td>
</tr>
<tr>
<td>city</td>
<td>str</td>
<td>Y</td>
<td>所在城市</td>
</tr>
<tr>
<td>introduction</td>
<td>str</td>
<td>N</td>
<td>公司介绍</td>
</tr>
<tr>
<td>website</td>
<td>str</td>
<td>Y</td>
<td>公司主页</td>
</tr>
<tr>
<td>email</td>
<td>str</td>
<td>Y</td>
<td>电子邮件</td>
</tr>
<tr>
<td>office</td>
<td>str</td>
<td>N</td>
<td>办公室</td>
</tr>
<tr>
<td>employees</td>
<td>int</td>
<td>Y</td>
<td>员工人数</td>
</tr>
<tr>
<td>main_business</td>
<td>str</td>
<td>N</td>
<td>主要业务及产品</td>
</tr>
<tr>
<td>business_scope</td>
<td>str</td>
<td>N</td>
<td>经营范围</td>
</tr>
</tbody></table>
接口示例

```
pro = ts.pro_api()

#或者
#pro = ts.pro_api('your token')

df = pro.stock_company(exchange='SZSE', fields='ts_code,chairman,manager,secretary,reg_capital,setup_date,province')

```

数据示例

```
                ts_code chairman manager secretary   reg_capital setup_date province  \
0     000001.SZ      谢永林     胡跃飞        周强  1.717041e+06   19871222       广东   
1     000002.SZ       郁亮     祝九胜        朱旭  1.103915e+06   19840530       广东   
2     000003.SZ      马钟鸿     马钟鸿        安汪  3.334336e+04   19880208       广东   
3     000004.SZ      李林琳     李林琳       徐文苏  8.397668e+03   19860505       广东   
4     000005.SZ       丁芃     郑列列       罗晓春  1.058537e+05   19870730       广东   
5     000006.SZ      赵宏伟     朱新宏        杜汛  1.349995e+05   19850525       广东   
6     000007.SZ      智德宇     智德宇       陈伟彬  3.464480e+04   19830311       广东   
7     000008.SZ      王志全      钟岩       王志刚  2.818330e+05   19891011       北京   
8     000009.SZ      陈政立     陈政立       郭山清  2.149345e+05   19830706       广东   
9     000010.SZ       曾嵘     李德友       金小刚  8.198547e+04   19881231       广东   
10    000011.SZ      刘声向     王航军       范维平  5.959791e+04   19830117       广东   
11    000012.SZ       陈琳      王健       杨昕宇  2.863277e+05   19840910       广东   
12    000013.SZ      厉怒江     阮克竖       刘渝敏  3.033550e+04   19920114       广东   
13    000014.SZ       陈勇      温毅        王凡  2.017052e+04   19870727       广东   
14    000015.SZ      宿南南      马骧       蒋孝安  1.598761e+05   19880408       广东   
15    000016.SZ      刘凤喜      周彬       吴勇军  2.407945e+05   19801001       广东  

```
