# 上市公司公告

**文档ID**: 176
**原始链接**: https://tushare.pro/document/2?doc_id=176

---

## 上市公司全量公告

接口：anns_d描述：获取全量公告数据，提供pdf下载URL限量：单次最大2000条数，可以跟进日期循环获取全量权限：本接口为单独权限，请参考权限说明

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>N</td>
<td>公告日期（yyyymmdd格式，下同）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>公告开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>公告结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ann_date</td>
<td>str</td>
<td>Y</td>
<td>公告日期</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>股票名称</td>
</tr>
<tr>
<td>title</td>
<td>str</td>
<td>Y</td>
<td>标题</td>
</tr>
<tr>
<td>url</td>
<td>str</td>
<td>Y</td>
<td>URL，原文下载链接</td>
</tr>
<tr>
<td>rec_time</td>
<td>datetime</td>
<td>N</td>
<td>发布时间</td>
</tr>
</tbody></table>
接口调用

```

pro = ts.pro_api()

df = pro.anns_d(ann_date='20230621')

```

数据样例

```
     ann_date    ts_code  name                                              title
0     20230621  600590.SH  泰豪科技                                   第八届董事会第十五次会议决议公告
1     20230621  300504.SZ  天邑股份                              天邑股份：关于回购注销部分限制性股票的公告
2     20230621  002815.SZ  崇达技术  崇达技术：中信建投证券股份有限公司关于崇达技术股份有限公司2022年限制性股票激励计划首次授...
3     20230621  600212.SH  绿能慧充                                绿能慧充2022年年度股东大会会议资料
4     20230621  002508.SZ  老板电器                              老板电器：关于向激励对象授予股票期权的公告
...        ...        ...   ...                                                ...
1995  20230620  600152.SH  维科技术        维科技术关于向2022年股票期权激励计划激励对象授予预留部分股票期权（第二批次）的公告
1996  20230620  301290.SZ  东星医疗                            东星医疗：关于对深圳证券交易所关注函的回复公告
1997  20230620  600998.SH   九州通       九州通关于控股股东2022年非公开发行可交换公司债券（第二、三期）进入换股期的提示性公告
1998  20230620  300371.SZ  汇中股份                                汇中股份：关于子公司完成工商变更的公告
1999  20230620  300061.SZ  旗天科技                                 旗天科技：关于为子公司提供担保的公告

[2000 rows x 4 columns]

```
