# Shibor报价数据

**文档ID**: 150
**原始链接**: https://tushare.pro/document/2?doc_id=150

---

## Shibor报价数据

接口：shibor_quote描述：Shibor报价数据限量：单次最大4000行数据，总量不限制，可通过设置开始和结束日期分段获取积分：用户积累120积分可以调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>N</td>
<td>日期 (日期输入格式：YYYYMMDD，下同)</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
<tr>
<td>bank</td>
<td>str</td>
<td>N</td>
<td>银行名称 （中文名称，例如 农业银行）</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>Y</td>
<td>日期</td>
</tr>
<tr>
<td>bank</td>
<td>str</td>
<td>Y</td>
<td>报价银行</td>
</tr>
<tr>
<td>on_b</td>
<td>float</td>
<td>Y</td>
<td>隔夜_Bid</td>
</tr>
<tr>
<td>on_a</td>
<td>float</td>
<td>Y</td>
<td>隔夜_Ask</td>
</tr>
<tr>
<td>1w_b</td>
<td>float</td>
<td>Y</td>
<td>1周_Bid</td>
</tr>
<tr>
<td>1w_a</td>
<td>float</td>
<td>Y</td>
<td>1周_Ask</td>
</tr>
<tr>
<td>2w_b</td>
<td>float</td>
<td>Y</td>
<td>2周_Bid</td>
</tr>
<tr>
<td>2w_a</td>
<td>float</td>
<td>Y</td>
<td>2周_Ask</td>
</tr>
<tr>
<td>1m_b</td>
<td>float</td>
<td>Y</td>
<td>1月_Bid</td>
</tr>
<tr>
<td>1m_a</td>
<td>float</td>
<td>Y</td>
<td>1月_Ask</td>
</tr>
<tr>
<td>3m_b</td>
<td>float</td>
<td>Y</td>
<td>3月_Bid</td>
</tr>
<tr>
<td>3m_a</td>
<td>float</td>
<td>Y</td>
<td>3月_Ask</td>
</tr>
<tr>
<td>6m_b</td>
<td>float</td>
<td>Y</td>
<td>6月_Bid</td>
</tr>
<tr>
<td>6m_a</td>
<td>float</td>
<td>Y</td>
<td>6月_Ask</td>
</tr>
<tr>
<td>9m_b</td>
<td>float</td>
<td>Y</td>
<td>9月_Bid</td>
</tr>
<tr>
<td>9m_a</td>
<td>float</td>
<td>Y</td>
<td>9月_Ask</td>
</tr>
<tr>
<td>1y_b</td>
<td>float</td>
<td>Y</td>
<td>1年_Bid</td>
</tr>
<tr>
<td>1y_a</td>
<td>float</td>
<td>Y</td>
<td>1年_Ask</td>
</tr>
</tbody></table>
接口调用

```

pro = ts.pro_api()

df = pro.shibor_quote(start_date='20180101', end_date='20181101')

```

数据样例

```
      date  bank   on_b   on_a  1w_b  1w_a  2w_b  2w_a   1m_b   1m_a  \
0     20181101  民生银行  2.540  2.540  2.65  2.65  2.67  2.67  2.680  2.680   
1     20181101   国开行  2.570  2.570  2.71  2.71  2.75  2.75  2.690  2.690   
2     20181101  邮储银行  2.550  2.550  2.72  2.72  2.72  2.72  2.690  2.690   
3     20181101  广发银行  2.560  2.560  2.66  2.66  2.68  2.68  2.720  2.720   
4     20181101  华夏银行  2.550  2.550  2.72  2.72  2.73  2.73  2.690  2.690   
5     20181101  汇丰中国  2.550  2.550  2.65  2.65  2.68  2.68  2.690  2.690   
6     20181101  上海银行  2.560  2.560  2.70  2.70  2.73  2.73  2.690  2.690   
7     20181101  北京银行  2.570  2.570  2.67  2.67  2.65  2.65  2.600  2.600   
8     20181101  浦发银行  2.560  2.560  2.75  2.75  2.65  2.65  2.700  2.700   
9     20181101  兴业银行  2.530  2.530  2.65  2.65  2.60  2.60  2.500  2.500   
10    20181101  光大银行  2.540  2.540  2.65  2.65  2.70  2.70  2.720  2.720   
11    20181101  中信银行  2.550  2.550  2.65  2.65  2.70  2.70  2.700  2.700   
12    20181101  招商银行  2.540  2.540  2.67  2.67  2.65  2.65  2.700  2.700   
13    20181101  交通银行  2.540  2.540  2.68  2.68  2.72  2.72  2.690  2.690   
14    20181101  建设银行  2.530  2.530  2.67  2.67  2.68  2.68  2.720  2.720   
15    20181101  中国银行  2.540  2.540  2.65  2.65  2.66  2.66  2.680  2.680   
16    20181101  农业银行  2.550  2.550  2.70  2.70  2.75  2.75  2.760  2.760   
17    20181101  工商银行  2.500  2.500  2.68  2.68  2.70  2.70  2.720  2.720   
18    20181031  民生银行  2.310  2.310  2.72  2.72  2.73  2.73  2.730  2.730   
19    20181031   国开行  2.370  2.370  2.75  2.75  2.76  2.76  2.690  2.690   
20    20181031  邮储银行  2.350  2.350  2.73  2.73  2.72  2.72  2.670  2.670 

   3m_b   3m_a   6m_b   6m_a   9m_b   9m_a   1y_b   1y_a  
0     2.960  2.960  3.290  3.290  3.510  3.510  3.550  3.550  
1     2.970  2.970  3.320  3.320  3.530  3.530  3.570  3.570  
2     2.960  2.960  3.300  3.300  3.500  3.500  3.550  3.550  
3     3.000  3.000  3.250  3.250  3.500  3.500  3.550  3.550  
4     2.970  2.970  3.300  3.300  3.510  3.510  3.550  3.550  
5     2.970  2.970  3.300  3.300  3.500  3.500  3.550  3.550  
6     2.960  2.960  3.300  3.300  3.510  3.510  3.550  3.550  
7     3.000  3.000  3.400  3.400  3.550  3.550  3.600  3.600  
8     2.960  2.960  3.300  3.300  3.500  3.500  3.550  3.550  
9     2.950  2.950  3.100  3.100  3.400  3.400  3.500  3.500  
10    3.000  3.000  3.300  3.300  3.500  3.500  3.550  3.550  
11    3.000  3.000  3.300  3.300  3.550  3.550  3.550  3.550  
12    3.100  3.100  3.300  3.300  3.550  3.550  3.550  3.550  
13    2.970  2.970  3.300  3.300  3.510  3.510  3.560  3.560  
14    3.000  3.000  3.260  3.260  3.500  3.500  3.550  3.550  
15    2.940  2.940  3.280  3.280  3.480  3.480  3.520  3.520  
16    3.000  3.000  3.300  3.300  3.500  3.500  3.550  3.550  
17    2.880  2.880  3.240  3.240  3.420  3.420  3.470  3.470  
18    2.970  2.970  3.300  3.300  3.500  3.500  3.550  3.550  
19    2.960  2.960  3.320  3.320  3.520  3.520  3.560  3.560  
20    2.960  2.960  3.300  3.300  3.500  3.500  3.550  3.550 
```
