# Shibor利率

**文档ID**: 149
**原始链接**: https://tushare.pro/document/2?doc_id=149

---

## Shibor利率数据

接口：shibor描述：shibor利率限量：单次最大2000，总量不限制，可通过设置开始和结束日期分段获取积分：用户积累120积分可以调取，具体请参阅积分获取办法

Shibor利率介绍

上海银行间同业拆放利率（Shanghai Interbank Offered Rate，简称Shibor），以位于上海的全国银行间同业拆借中心为技术平台计算、发布并命名，是由信用等级较高的银行组成报价团自主报出的人民币同业拆出利率计算确定的算术平均利率，是单利、无担保、批发性利率。目前，对社会公布的Shibor品种包括隔夜、1周、2周、1个月、3个月、6个月、9个月及1年。

Shibor报价银行团现由18家商业银行组成。报价银行是公开市场一级交易商或外汇市场做市商，在中国货币市场上人民币交易相对活跃、信息披露比较充分的银行。中国人民银行成立Shibor工作小组，依据《上海银行间同业拆放利率（Shibor）实施准则》确定和调整报价银行团成员、监督和管理Shibor运行、规范报价行与指定发布人行为。

全国银行间同业拆借中心受权Shibor的报价计算和信息发布。每个交易日根据各报价行的报价，剔除最高、最低各4家报价，对其余报价进行算术平均计算后，得出每一期限品种的Shibor，并于11:00对外发布。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>N</td>
<td>日期 (日期输入格式：YYYYMMDD，下同)</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>Y</td>
<td>日期</td>
</tr>
<tr>
<td>on</td>
<td>float</td>
<td>Y</td>
<td>隔夜</td>
</tr>
<tr>
<td>1w</td>
<td>float</td>
<td>Y</td>
<td>1周</td>
</tr>
<tr>
<td>2w</td>
<td>float</td>
<td>Y</td>
<td>2周</td>
</tr>
<tr>
<td>1m</td>
<td>float</td>
<td>Y</td>
<td>1个月</td>
</tr>
<tr>
<td>3m</td>
<td>float</td>
<td>Y</td>
<td>3个月</td>
</tr>
<tr>
<td>6m</td>
<td>float</td>
<td>Y</td>
<td>6个月</td>
</tr>
<tr>
<td>9m</td>
<td>float</td>
<td>Y</td>
<td>9个月</td>
</tr>
<tr>
<td>1y</td>
<td>float</td>
<td>Y</td>
<td>1年</td>
</tr>
</tbody></table>
接口调用

```

pro = ts.pro_api()

df = pro.shibor(start_date='20180101', end_date='20181101')

```

数据样例

```
     date      on      1w      2w      1m      3m      6m      9m      1y
0    20181101  2.5470  2.6730  2.6910  2.6960  2.9760  3.2970  3.5040  3.5500
1    20181031  2.3700  2.7150  2.7300  2.6890  2.9630  3.2980  3.5040  3.5500
2    20181030  1.5660  2.5980  2.6400  2.6630  2.9570  3.2950  3.5010  3.5500
3    20181029  1.8520  2.6090  2.6510  2.6720  2.9580  3.2970  3.5020  3.5500
4    20181026  2.0670  2.6180  2.6500  2.6730  2.9520  3.2970  3.5020  3.5500
5    20181025  2.2150  2.6300  2.6510  2.6750  2.9480  3.2970  3.5050  3.5520
6    20181024  2.3930  2.6310  2.6530  2.6750  2.9240  3.2960  3.4980  3.5440
7    20181023  2.4510  2.6350  2.6530  2.6720  2.9030  3.2890  3.4880  3.5320
8    20181022  2.4750  2.6320  2.6500  2.6630  2.8710  3.2770  3.4710  3.5160
9    20181019  2.4450  2.6220  2.6480  2.6550  2.8420  3.2670  3.4560  3.5070
10   20181018  2.4270  2.6110  2.6370  2.6510  2.8320  3.2600  3.4530  3.5040
11   20181017  2.3530  2.6040  2.6320  2.6510  2.8180  3.2540  3.4500  3.5050
12   20181016  2.3730  2.6030  2.6330  2.6580  2.8000  3.2530  3.4500  3.5050
13   20181015  2.3770  2.6120  2.6370  2.6680  2.8010  3.2530  3.4510  3.5050
14   20181012  2.4390  2.6150  2.6440  2.6820  2.8000  3.2500  3.4530  3.5050
15   20181011  2.3600  2.6110  2.6500  2.6920  2.8010  3.2510  3.4550  3.5060
16   20181010  2.3980  2.6180  2.6730  2.7050  2.8100  3.2530  3.4590  3.5020
17   20181009  2.5020  2.6330  2.7030  2.7340  2.8160  3.2580  3.4640  3.5040
18   20181008  2.5360  2.6570  2.7660  2.7810  2.8360  3.2690  3.4760  3.5120
19   20180930  2.6530  2.7660  3.4730  2.8020  2.8470  3.2870  3.4890  3.5210
20   20180929  2.0730  2.7830  3.3100  2.8020  2.8460  3.2850  3.4890  3.5210
```
