# Libor利率

**文档ID**: 152
**原始链接**: https://tushare.pro/document/2?doc_id=152

---

## Libor拆借利率

接口：libor描述：Libor拆借利率限量：单次最大4000行数据，总量不限制，可通过设置开始和结束日期分段获取积分：用户积累120积分可以调取，具体请参阅积分获取办法

Libor（London Interbank Offered Rate ），即伦敦同业拆借利率，是指伦敦的第一流银行之间短期资金借贷的利率，是国际金融市场中大多数浮动利率的基础利率。作为银行从市场上筹集资金进行转贷的融资成本，贷款协议中议定的LIBOR通常是由几家指定的参考银行，在规定的时间（一般是伦敦时间上午11：00）报价的平均利率。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>N</td>
<td>日期 (日期输入格式：YYYYMMDD，下同)</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
<tr>
<td>curr_type</td>
<td>str</td>
<td>N</td>
<td>货币代码  (USD美元  EUR欧元  JPY日元  GBP英镑  CHF瑞郎，默认是USD)</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>Y</td>
<td>日期</td>
</tr>
<tr>
<td>curr_type</td>
<td>str</td>
<td>Y</td>
<td>货币</td>
</tr>
<tr>
<td>on</td>
<td>float</td>
<td>Y</td>
<td>隔夜</td>
</tr>
<tr>
<td>1w</td>
<td>float</td>
<td>Y</td>
<td>1周</td>
</tr>
<tr>
<td>1m</td>
<td>float</td>
<td>Y</td>
<td>1个月</td>
</tr>
<tr>
<td>2m</td>
<td>float</td>
<td>Y</td>
<td>2个月</td>
</tr>
<tr>
<td>3m</td>
<td>float</td>
<td>Y</td>
<td>3个月</td>
</tr>
<tr>
<td>6m</td>
<td>float</td>
<td>Y</td>
<td>6个月</td>
</tr>
<tr>
<td>12m</td>
<td>float</td>
<td>Y</td>
<td>12个月</td>
</tr>
</tbody></table>
接口调用

```

pro = ts.pro_api()

df = pro.libor(curr_type='USD', start_date='20180101', end_date='20181130')

```

数据样例

```
     date     curr_type       on       1w       1m       2m       3m       6m  \
0    20181130       USD  2.17750  2.22131  2.34694  2.51006  2.73613  2.89463   
1    20181129       USD  2.18275  2.22881  2.34925  2.51125  2.73813  2.88519   
2    20181128       USD  2.18250  2.22450  2.34463  2.49500  2.70663  2.88663   
3    20181127       USD  2.17850  2.23494  2.34931  2.49900  2.70600  2.88444   
4    20181126       USD  2.18300  2.21900  2.33675  2.49525  2.70681  2.89275   
5    20181123       USD  2.17700  2.22188  2.32188  2.49538  2.69119  2.88625   
6    20181122       USD      NaN  2.22213  2.31488  2.48013  2.68925  2.88725   
7    20181121       USD  2.18050  2.22100  2.31513  2.47313  2.67694  2.88588   
8    20181120       USD  2.17288  2.21638  2.30550  2.45850  2.65313  2.86325   
9    20181119       USD  2.18075  2.21725  2.30025  2.45769  2.64581  2.86575   
10   20181116       USD  2.17538  2.21225  2.30088  2.45213  2.64450  2.86263   
11   20181115       USD  2.17938  2.21125  2.30250  2.44913  2.64000  2.86019   
12   20181114       USD  2.17575  2.20963  2.31038  2.44531  2.62900  2.86344   
13   20181113       USD  2.17788  2.21613  2.30650  2.44413  2.61613  2.85500   
14   20181112       USD      NaN  2.21550  2.30663  2.44525  2.61413  2.85538   
15   20181109       USD  2.17500  2.21913  2.31438  2.45513  2.61813  2.85800   
16   20181108       USD  2.17988  2.21619  2.31844  2.45863  2.61463  2.85763   
17   20181107       USD  2.17725  2.21588  2.31531  2.44550  2.60113  2.84350   
18   20181106       USD  2.17663  2.21138  2.31688  2.42863  2.59125  2.84150   
19   20181105       USD  2.17525  2.21425  2.31600  2.42950  2.58925  2.83575   
20   20181102       USD  2.17463  2.21400  2.31788  2.42625  2.59238  2.82888 

         12m  
0    3.12025  
1    3.11869  
2    3.13413  
3    3.13075  
4    3.12838  
5    3.12075  
6    3.10950  
7    3.11038  
8    3.09713  
9    3.10738  
10   3.12363  
11   3.11838  
12   3.12963  
13   3.13206  
14   3.13475  
15   3.14413  
16   3.14075  
17   3.12513  
18   3.11638  
19   3.11688  
20   3.10488 
```
