# LPR贷款基础利率

**文档ID**: 151
**原始链接**: https://tushare.pro/document/2?doc_id=151

---

## LPR贷款基础利率

接口：shibor_lpr描述：LPR贷款基础利率限量：单次最大4000(相当于单次可提取18年历史)，总量不限制，可通过设置开始和结束日期分段获取积分：用户积累120积分可以调取，具体请参阅积分获取办法

LPR介绍

贷款基础利率（Loan Prime Rate，简称LPR），是基于报价行自主报出的最优贷款利率计算并发布的贷款市场参考利率。目前，对社会公布1年期贷款基础利率。

LPR报价银行团现由10家商业银行组成。报价银行应符合财务硬约束条件和宏观审慎政策框架要求，系统重要性程度高、市场影响力大、综合实力强，已建立内部收益率曲线和内部转移定价机制，具有较强的自主定价能力，已制定本行贷款基础利率管理办法，以及有利于开展报价工作的其他条件。市场利率定价自律机制依据《贷款基础利率集中报价和发布规则》确定和调整报价行成员，监督和管理贷款基础利率运行，规范报价行与指定发布人行为。

全国银行间同业拆借中心受权贷款基础利率的报价计算和信息发布。每个交易日根据各报价行的报价，剔除最高、最低各1家报价，对其余报价进行加权平均计算后，得出贷款基础利率报价平均利率，并于11:30对外发布。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>N</td>
<td>日期  (日期输入格式：YYYYMMDD，下同)</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>Y</td>
<td>日期</td>
</tr>
<tr>
<td>1y</td>
<td>float</td>
<td>Y</td>
<td>1年贷款利率</td>
</tr>
<tr>
<td>5y</td>
<td>float</td>
<td>Y</td>
<td>5年贷款利率</td>
</tr>
</tbody></table>
接口调用

```

pro = ts.pro_api()

df = pro.shibor_lpr(start_date='20180101', end_date='20181130', fields='date,1y')

```

数据样例

```
     date       1y
0    20181130  4.31
1    20181129  4.31
2    20181128  4.31
3    20181127  4.31
4    20181126  4.31
5    20181123  4.31
6    20181122  4.31
7    20181121  4.31
8    20181120  4.31
9    20181119  4.31
10   20181116  4.31
11   20181115  4.31
12   20181114  4.31
13   20181113  4.31
14   20181112  4.31
15   20181109  4.31
16   20181108  4.31
17   20181107  4.31
18   20181106  4.31
19   20181105  4.31
20   20181102  4.31

```
