# Hibor利率

**文档ID**: 153
**原始链接**: https://tushare.pro/document/2?doc_id=153

---

## Hibor利率

接口：hibor描述：Hibor利率限量：单次最大4000行数据，总量不限制，可通过设置开始和结束日期分段获取积分：用户积累120积分可以调取，具体请参阅积分获取办法

HIBOR (Hongkong InterBank Offered Rate)，是香港银行同行业拆借利率。指香港货币市场上，银行与银行之间的一年期以下的短期资金借贷利率，从伦敦同业拆借利率（LIBOR）变化出来的。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>N</td>
<td>日期  (日期输入格式：YYYYMMDD，下同)</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>Y</td>
<td>日期</td>
</tr>
<tr>
<td>on</td>
<td>float</td>
<td>Y</td>
<td>隔夜</td>
</tr>
<tr>
<td>1w</td>
<td>float</td>
<td>Y</td>
<td>1周</td>
</tr>
<tr>
<td>2w</td>
<td>float</td>
<td>Y</td>
<td>2周</td>
</tr>
<tr>
<td>1m</td>
<td>float</td>
<td>Y</td>
<td>1个月</td>
</tr>
<tr>
<td>2m</td>
<td>float</td>
<td>Y</td>
<td>2个月</td>
</tr>
<tr>
<td>3m</td>
<td>float</td>
<td>Y</td>
<td>3个月</td>
</tr>
<tr>
<td>6m</td>
<td>float</td>
<td>Y</td>
<td>6个月</td>
</tr>
<tr>
<td>12m</td>
<td>float</td>
<td>Y</td>
<td>12个月</td>
</tr>
</tbody></table>
接口调用

```

pro = ts.pro_api()

df = pro.hibor(start_date='20180101', end_date='20181130')

```

数据样例

```
     date       on       1w       2w       1m       2m       3m       6m  \
0    20181130  1.52500  1.10125  1.08000  1.20286  1.83030  2.03786  2.32821   
1    20181129  0.76143  0.95643  1.01036  1.12357  1.80493  2.01018  2.31643   
2    20181128  0.66786  0.95607  0.99929  1.10964  1.77104  1.97643  2.30143   
3    20181127  0.71357  0.95536  0.99786  1.09321  1.76321  1.98351  2.30374   
4    20181126  0.68821  0.92821  0.99107  1.08214  1.75161  1.97742  2.29957   
5    20181123  0.68571  0.84000  0.91036  1.08214  1.75304  1.97591  2.30088   
6    20181122  0.47161  0.59750  0.76750  1.01214  1.73125  1.96500  2.29250   
7    20181121  0.36893  0.56571  0.74429  0.98929  1.71071  1.96569  2.29286   
8    20181120  0.38964  0.58214  0.75464  1.01107  1.70839  1.96571  2.28893   
9    20181119  0.39672  0.59893  0.77464  1.04143  1.71143  1.96643  2.28643   
10   20181116  0.44429  0.60321  0.75214  1.04429  1.71500  1.96750  2.28893   
11   20181115  0.39179  0.63571  0.77857  1.04627  1.71722  1.97607  2.28697   
12   20181114  0.34571  0.64026  0.78821  1.06393  1.72875  2.00000  2.29554   
13   20181113  0.59232  0.82643  0.91643  1.09286  1.77786  2.06920  2.30982   
14   20181112  0.53571  0.75419  0.83321  1.03536  1.75734  2.08286  2.29929   
15   20181109  0.51571  0.75393  0.83321  1.03464  1.76018  2.08179  2.30283   
16   20181108  0.60536  0.75293  0.85179  1.03357  1.75866  2.08107  2.29907   
17   20181107  0.58071  0.72679  0.83107  1.04714  1.74804  2.08467  2.30446   
18   20181106  0.48714  0.67750  0.78786  1.02536  1.72821  2.08071  2.30589   
19   20181105  0.44929  0.68500  0.80214  1.04321  1.72500  2.08179  2.31941   
20   20181102  0.45571  0.73542  0.87679  1.10536  1.73732  2.10018  2.33276

         12m  
0    2.65929  
1    2.65500  
2    2.65643  
3    2.65571  
4    2.65446  
5    2.65375  
6    2.64750  
7    2.64618  
8    2.63946  
9    2.63960  
10   2.64321  
11   2.64286  
12   2.64857  
13   2.66286  
14   2.65607  
15   2.65857  
16   2.65357  
17   2.65596  
18   2.65464  
19   2.65857  
20   2.67857  
```
