---
name: tushare
description: Fetch Chinese stock and futures market data via Tushare API. Supports stock quotes, futures data, company fundamentals, and macroeconomic indicators. Use when the user needs financial data from Chinese markets. Requires TUSHARE_TOKEN environment variable.
---

# Tushare 金融数据接口

获取中国 A 股市场和期货市场的实时及历史数据。

## 前提条件

### 1. 注册 Tushare 账号

访问 https://tushare.pro/register 注册账号并获取 API Token。

### 2. 配置 Token

```bash
# 添加到 ~/.zshrc
export TUSHARE_TOKEN="your-api-token-here"
```

然后执行：
```bash
source ~/.zshrc
```

### 3. 安装依赖

```bash
pip3 install tushare pandas --user
```

## 快速开始

### 获取股票列表

```bash
python3 scripts/market.py stock_basic
```

### 获取日线行情

```bash
python3 scripts/market.py daily --ts_code 000001.SZ --start_date 20240101 --end_date 20240131
```

### 获取实时行情

```bash
python3 scripts/market.py realtime 000001
```

## 股票数据

### 股票基础信息

```bash
python3 scripts/market.py stock_basic
python3 scripts/market.py stock_basic --exchange SSE  # 仅上交所
python3 scripts/market.py stock_basic --exchange SZSE  # 仅深交所
```

### 日线行情

```bash
# 获取单只股票近期数据
python3 scripts/market.py daily --ts_code 000001.SZ

# 指定日期范围
python3 scripts/market.py daily --ts_code 600519.SH --start_date 20240101 --end_date 20240131

# 获取指定交易日全市场数据
python3 scripts/market.py daily --trade_date 20240115
```

### 周线行情

```bash
# 获取周线数据
python3 scripts/market.py weekly --ts_code 000001.SZ

# 指定日期范围
python3 scripts/market.py weekly --ts_code 600519.SH --start_date 20230101 --end_date 20240131
```

### 月线行情

```bash
# 获取月线数据
python3 scripts/market.py monthly --ts_code 000001.SZ

# 指定日期范围
python3 scripts/market.py monthly --ts_code 600519.SH --start_date 20200101 --end_date 20240131
```

**股票代码格式**：
- 深交所：`000001.SZ`, `000002.SZ`, `300001.SZ` (创业板)
- 上交所：`600000.SH`, `600519.SH`, `688001.SH` (科创板)

### 实时行情

```bash
python3 scripts/market.py realtime 000001
python3 scripts/market.py realtime 600519
```

### 资金流向

```bash
# 获取指定股票资金流向
python3 scripts/market.py moneyflow --ts_code 000001.SZ

# 获取指定日期全市场资金流向
python3 scripts/market.py moneyflow --trade_date 20240115
```

### 公司信息

```bash
python3 scripts/market.py company
```

## 期货数据

### 期货合约基础信息

```bash
python3 scripts/market.py fut_basic

# 指定交易所
python3 scripts/market.py fut_basic --exchange CFFEX  # 中金所
python3 scripts/market.py fut_basic --exchange SHFE   # 上期所
python3 scripts/market.py fut_basic --exchange DCE    # 大商所
python3 scripts/market.py fut_basic --exchange CZCE   # 郑商所
```

**交易所代码**：
- `CFFEX` - 中国金融期货交易所
- `SHFE` - 上海期货交易所
- `DCE` - 大连商品交易所
- `CZCE` - 郑州商品交易所
- `INE` - 上海国际能源交易中心

### 期货日线行情

```bash
# 获取铜期货数据
python3 scripts/market.py fut_daily --ts_code CU.SHF

# 获取沪深300股指期货
python3 scripts/market.py fut_daily --ts_code IF.CFX

# 指定日期范围
python3 scripts/market.py fut_daily --ts_code RB.SHF --start_date 20240101 --end_date 20240131
```

**期货代码格式**：
- 上期所：`CU.SHF` (铜), `RB.SHF` (螺纹钢), `AU.SHF` (黄金)
- 大商所：`M.DCE` (豆粕), `I.DCE` (铁矿石)
- 郑商所：`SR.CZC` (白糖), `CF.CZC` (棉花)
- 中金所：`IF.CFX` (沪深300), `IC.CFX` (中证500)

### 期货持仓排名

```bash
python3 scripts/market.py fut_holding --trade_date 20240115 --symbol CU
```

## 宏观经济

### GDP 数据

```bash
python3 scripts/market.py gdp
```

输出示例：
```
📈 GDP数据 (88 条):

2023年4季度: GDP 347909亿元, 增速 5.2%
2023年3季度: GDP 319992亿元, 增速 4.9%
...
```

### CPI 数据

```bash
python3 scripts/market.py cpi
```

### PPI 数据

```bash
python3 scripts/market.py ppi
```

## 命令速查表

| 命令 | 功能 | 示例 |
|------|------|------|
| `stock_basic` | 股票基础信息 | `--exchange SSE` |
| `daily` | 日线行情 | `--ts_code 000001.SZ --start_date 20240101` |
| `weekly` | 周线行情 | `--ts_code 000001.SZ --start_date 20230101` |
| `monthly` | 月线行情 | `--ts_code 000001.SZ --start_date 20200101` |
| `realtime` | 实时行情 | `000001` |
| `moneyflow` | 资金流向 | `--ts_code 000001.SZ` |
| `company` | 公司信息 | - |
| `fut_basic` | 期货基础信息 | `--exchange SHFE` |
| `fut_daily` | 期货日线 | `--ts_code CU.SHF` |
| `fut_holding` | 持仓排名 | `--symbol CU` |
| `gdp` | GDP数据 | - |
| `cpi` | CPI数据 | - |
| `ppi` | PPI数据 | - |

## 常见问题

**错误：请设置 TUSHARE_TOKEN 环境变量**
→ 在 `~/.zshrc` 中添加 `export TUSHARE_TOKEN="your-token"` 并执行 `source ~/.zshrc`

**错误：没有数据返回**
→ 检查股票/期货代码格式是否正确（如：000001.SZ, CU.SHF）

**错误：权限不足**
→ Tushare 部分接口需要积分或付费权限，请在官网查看接口权限要求

**如何获取股票代码？**
```bash
python3 scripts/market.py stock_basic | grep "平安"
```

## 参考文档

- 股票接口文档: [references/stock_api.md](references/stock_api.md)
- 期货接口文档: [references/futures_api.md](references/futures_api.md)
- Tushare 官网: https://tushare.pro
