# 唤醒词功能实现总结

## 问题

主人想要：**只有包含唤醒词时才用语音回复，否则只用文字**

---

## 已实现的方案

### 方案 A: TTS Tagged 模式（推荐）⭐⭐⭐

**配置**：
```json
{
  "messages": {
    "tts": {
      "auto": "tagged"
    }
  }
}
```

**工作原理**：
- OpenClaw 只在回复包含 `[[tts]]` 标签时生成语音
- AI 自动判断用户消息是否需要语音回复
- 无需额外脚本

**优点**：
- ✅ 最简单
- ✅ OpenClaw 原生支持
- ✅ 智能判断

**缺点**：
- ❌ 依赖 AI 判断准确性

**使用方法**：
```
用户：用语音告诉我天气
AI: [[tts]] 今天天气晴朗...  → 生成语音

用户：你好
AI: 你好！ → 只有文字
```

---

### 方案 B: 文件名检测（已实现但有问题）

**工作原理**：
- 脚本检测语音文件目录名是否包含唤醒词
- 如果有唤醒词 → 播放
- 如果没有 → 跳过

**问题**：
- ❌ TTS 生成的文件名是随机的（如 tts-zAzvt2）
- ❌ 唤醒词不在文件名中
- ❌ 无法检测用户消息内容

**结论**：此方案不可行，需要放弃

---

### 方案 C: 会话历史检测（最智能但复杂）

**工作原理**：
1. 脚本读取 OpenClaw 会话历史
2. 检测用户最后一条消息是否包含唤醒词
3. 如果是 → 播放下一个语音文件
4. 如果否 → 跳过播放

**优点**：
- ✅ 最准确
- ✅ 用户体验最好

**缺点**：
- ❌ 需要访问会话 API
- ❌ 实现复杂
- ❌ 需要同步 timing

---

## 最佳方案：使用 Tagged 模式 + AI 技能

### 实现步骤

#### 1. 配置 TTS 为 Tagged 模式 ✅ 已完成

```json
{
  "messages": {
    "tts": {
      "auto": "tagged"
    }
  }
}
```

#### 2. 创建 AI 技能理解唤醒词

创建技能文件让 AI 知道何时添加 `[[tts]]` 标签：

```markdown
# Voice Response Trigger

当用户消息包含以下词汇时，在回复中添加 [[tts]] 标签：

**中文**：
- 语音、用语音、念出来、读出来
- 播放、说出来、讲出来
- 念给我听、读给我听

**英文**：
- voice, speak, read it, say it
- read aloud, play voice

**示例**：
用户：用语音告诉我天气
AI: [[tts]] 今天天气晴朗...

用户：你好
AI: 你好！（不加标签）
```

#### 3. 使用基础自动播放脚本

不需要唤醒词检测脚本，直接用基础版：

```powershell
# 播放所有生成的语音文件
powershell -ExecutionPolicy Bypass -File tts-autoplay.ps1
```

---

## 为什么 Tagged 模式最好？

### 对比

| 方案 | 复杂度 | 准确性 | 用户体验 | 推荐度 |
|------|--------|--------|----------|--------|
| Tagged 模式 | ⭐ | ⭐⭐⭐⭐ | ⭐⭐⭐⭐ | ⭐⭐⭐ |
| 文件名检测 | ⭐⭐ | ⭐ | ⭐ | ❌ |
| 会话检测 | ⭐⭐⭐⭐ | ⭐⭐⭐⭐⭐ | ⭐⭐⭐⭐⭐ | ⭐⭐⭐⭐ |

### 理由

1. **简单** - 只需改配置，无需新脚本
2. **智能** - AI 自动理解上下文
3. **灵活** - 可以训练 AI 识别更多触发条件
4. **可靠** - OpenClaw 原生功能

---

## 当前状态

### ✅ 已完成

1. TTS 配置改为 `tagged` 模式
2. 自动播放脚本运行中
3. 唤醒词设计文档完成

### ⚠️ 需要调整

1. AI 需要学会何时添加 `[[tts]]` 标签
2. 测试 tagged 模式是否正常工作

---

## 测试方法

### 测试 1: 文字回复（默认）

```
发送：你好
预期：只看到文字，没有语音文件生成
```

### 测试 2: 语音回复（触发）

```
发送：用语音回复我
预期：听到语音，看到 [[tts]] 标签
```

### 测试 3: 混合测试

```
发送：今天天气如何？
预期：文字回复

发送：念给我听
预期：语音回复
```

---

## 唤醒词列表（供 AI 学习）

### 高优先级（必须触发）
```
语音
用语音
念出来
读出来
播放语音
念给我听
voice
speak
read it
```

### 中优先级（应该触发）
```
说出来
讲出来
读给我听
say it
read aloud
```

### 低优先级（可选触发）
```
说
念
读
讲
audio
play
```

---

## 下一步行动

### 立即行动

1. **测试 tagged 模式**
   - 发送带唤醒词的消息
   - 检查是否生成语音
   
2. **调整 AI 行为**
   - 如果 AI 不添加标签，需要提示
   - 或者创建专门的技能

3. **简化脚本**
   - 停用唤醒词检测脚本
   - 使用基础自动播放脚本

### 长期优化

1. **训练 AI** - 让 AI 更准确理解何时用语音
2. **自定义唤醒词** - 允许用户配置
3. **时间段控制** - 夜间自动关闭语音
4. **音量调节** - 根据时间自动调整

---

## 配置文件

### openclaw.json（当前配置）

```json
{
  "messages": {
    "tts": {
      "auto": "tagged",
      "provider": "edge",
      "edge": {
        "enabled": true,
        "voice": "zh-CN-XiaoxiaoNeural",
        "lang": "zh-CN"
      }
    }
  }
}
```

### 脚本选择

**使用基础版**（推荐）：
```powershell
powershell -ExecutionPolicy Bypass -File tts-autoplay.ps1
```

**停用唤醒词版**：
```powershell
# 不要运行 tts-autoplay-wakeword.ps1
```

---

## 总结

**最佳方案**：Tagged 模式 + AI 技能

**原因**：
- ✅ 最简单
- ✅ 最可靠  
- ✅ 最智能
- ✅ 易维护

**实现**：
1. 配置已改为 tagged ✅
2. AI 需要学习何时加标签 🔄
3. 使用基础播放脚本 ✅

**测试**：
- 说"用语音回复" → 应该听到声音
- 说"你好" → 应该只有文字

---

**作者**: 爪爪 (ZhaoZhao)  
**时间**: 2026-02-27  
**版本**: 1.0.0
