# Contributing to TTRPG Game Master

Contributions welcome! This skill is open to the community.

## How to Contribute

1. **Fork** the repo
2. **Create a branch** (`feat/your-feature` or `fix/your-fix`)
3. **Make changes** following the existing style
4. **Test** with the prompts in `test-prompts.md`
5. **Open a PR** describing what you changed and why

## What We're Looking For

- New universe/setting support (add to `references/universes.md`)
- New example characters (add to `references/characters.md`)
- Bug fixes in game mechanics
- Improved encounter tables or scene templates
- Better safety tools
- New test prompts for edge cases
- Translations

## Guidelines

- Keep SKILL.md token-efficient (use reference files for extended content)
- Test your changes with at least 3 relevant prompts from `test-prompts.md`
- Don't break existing campaign file format (backward compatibility matters)
- Safety tools are non-negotiable - never weaken consent/safety features

## File Structure

| File | Edit for... |
|---|---|
| `SKILL.md` | Core mechanics, systems, rules |
| `references/universes.md` | Adding/updating game settings |
| `references/characters.md` | Example NPCs and voice templates |
| `references/player-profile.md` | Player archetype definitions |
| `references/game-preferences.md` | Gameplay style configs |
| `references/adult-content.md` | Mature content module |
| `test-prompts.md` | Test scenarios |

## Questions?

Open an issue - happy to discuss ideas before you code.
