---
name: tron-x402-payment
description: "Pay for x402-enabled Agent endpoints using TRC20 tokens (USDT/USDD) on TRON"
version: 1.1.0
author: open-aibank
homepage: https://x402.org
metadata: {"clawdbot":{"emoji":"💳","env":["TRON_PRIVATE_KEY"]}}
tags: [crypto, payments, x402, agents, api, usdt, usdd, tron]
requires_tools: [x402_tron_invoke]
# Tool implementation mapping: x402_tron_invoke -> dist/x402_tron_invoke.js
arguments:
  url:
    description: "Base URL of the agent (v2) or full URL (v1/Discovery)"
    required: true
  entrypoint:
    description: "Entrypoint name to invoke (e.g., 'chat', 'search')"
    required: false
  input:
    description: "Input object to send to the entrypoint (will be wrapped in {\"input\": ...} for v2)"
    required: false
---

# x402 Payment Protocol for TRON Agents

Invoke x402-enabled AI agent endpoints with automatic TRC20 token payments on TRON.
Currently recommended tokens: **USDT**, **USDD**.

## Quick Start

The tool `x402_tron_invoke` is implemented by the compiled script `dist/x402_tron_invoke.js`.

The script is pre-built and ready to run. You can execute it directly from the command line:

```bash
# v2 Invoke
node dist/x402_tron_invoke.js --url https://api.example.com --entrypoint chat --input '{"prompt": "hi"}'

# Direct/Discovery
node dist/x402_tron_invoke.js --url https://api.example.com/.well-known/agent.json
```

---

## How It Works

The `x402_tron_invoke` tool:

1. Constructs the endpoint URL:
   - If `entrypoint` is provided: `{url}/entrypoints/{entrypoint}/invoke` (v2)
   - Otherwise: Uses `{url}` as-is (v1 / Discovery)
2. Makes a request (POST for v2, GET default for v1)
3. If 402 Payment Required is returned:
    - Parses payment requirements
    - Checks wallet balance and allowance
    - Performs an **infinite approval** if allowance is insufficient
    - Signs the payment permit (EIP-712 / TRON Typed Data)
    - Retries the request with `X-PAYMENT` header
4. Returns the response

## Prerequisites

- **Wallet**: A TRON private key must be available. The skill automatically looks for it in:
  1. `TRON_PRIVATE_KEY` environment variable.
  2. `~/.mcporter/mcporter.json` (AIBank standard).
  3. `x402-config.json` in the current/home directory.
- **Tokens**: Wallet needs USDT/USDD and some TRX for gas.
- **TronGrid API Key**: Required for **Mainnet** to avoid rate limits (`TRON_GRID_API_KEY`).

---

## Tool Reference

### x402_tron_invoke

Invokes an HTTP endpoint with automatic payment handling.

**Modes:**
1.  **v2 Agent Invoke** (Recommended): Provide `url` (Base URL) + `entrypoint`.
    *   Constructs: `{url}/entrypoints/{entrypoint}/invoke`
    *   Wraps input: `{"input": <input>}`
    *   Method: `POST`
2.  **v1 / Direct / Discovery**: Provide `url` (Full URL) without `entrypoint`.
    *   Uses the URL as-is.
    *   Method: `GET` (default) or specified via `method`.
    *   **Agent Advice**: Use this mode for discovery. If `url` returns 404, try appending `/.well-known/agent.json` or `/entrypoints`.
3.  **Status Check**: Provide `--check` or `--status`.
    *   Verifies if `TRON_PRIVATE_KEY` is correctly configured and outputs the associated wallet address.
    *   Checks if `TRON_GRID_API_KEY` is present (Required for Mainnet).
    *   **Agent Advice**: ALWAYS use this instead of `env` or `echo $TRON_PRIVATE_KEY`.

| Parameter | Type | Required | Description |
|-----------|------|----------|-------------|
| `url` | string | Yes* | Base URL (v2) or Full URL (v1/Discovery). *Not required for `--check`. |
| `entrypoint` | string | No | Entrypoint name. Required for v2 Invoke. |
| `input` | object | No | Input data. |
| `method` | string | No | HTTP method. Default: `POST` (v2), `GET` (Direct). |
| `network` | string | No | `mainnet`, `nile`, `shasta` (Default: `nile`). |
| `check` | boolean | No | Verify wallet configuration and output address. |

### Example: Chat with Agent (v2 Invoke)

```bash
node dist/x402_tron_invoke.js --url https://api.example.com --entrypoint chat --input '{"prompt": "Tell me a joke"}'
```
*(Sends `POST https://api.example.com/entrypoints/chat/invoke`)*

### Example: Agent Discovery (Direct)

1. **Manifest**: Fetch agent metadata.
   ```bash
   node dist/x402_tron_invoke.js --url https://api.example.com/.well-known/agent.json
   ```

2. **List Entrypoints**: List available functions.
   ```bash
   node dist/x402_tron_invoke.js --url https://api.example.com/entrypoints
   ```
   Each entrypoint typically returns:
   - **Path**: `/entrypoints/{name}/invoke`
   - **Pricing**: Cost in tokens (e.g., 1000 units)
   - **Network**: Usually `nile` or `mainnet`
   - **Input Schema**: Expected JSON format for the `input` parameter

### Example: Raw URL (Legacy)

```bash
node dist/x402_tron_invoke.js --url https://api.example.com/chat --method POST --input '{"prompt": "Tell me a joke"}'
```

---

## Cost Reference (USDT/USDD)

| Token | Network | Contract Address | Decimals |
|-------|---------|------------------|----------|
| USDT  | Mainnet | `TR7NHqjeKQxGTCi8q8ZY4pL8otSzgjLj6t` | 6 |
| USDT  | Nile    | `TXYZopYRdj2D9XRtbG411XZZ3kM5VkAeBf` | 6 |
| USDT  | Shasta  | `TG3XXyExBkPp9nzdajDZsozEu4BkaSJozs` | 6 |
| USDD  | Mainnet | `TXDk8mbtRbXeYuMNS83CfKPaYYT8XWv9Hz` | 18 |
| USDD  | Nile    | `TGjgvdTWWrybVLaVeFqSyVqJQWjxqRYbaK` | 18 |

| Amount (raw) | Value (USDT, 6 dec) | Typical Use |
|--------------|---------------------|-------------|
| 1000 | $0.001 | Single API call |
| 5000 | $0.005 | Multiple results |
| 10000 | $0.01 | Premium request |
| 1000000 | $1.00 | Large batch |

---

## Understanding 402 Responses

When payment is required, agents return:

```json
{
  "error": "X-PAYMENT header is required",
  "accepts": [{
    "scheme": "exact",
    "network": "nile",
    "maxAmountRequired": "1000",
    "payTo": "T...",
    "asset": "T..."
  }],
  "x402Version": 1
}
```

The tool handles this automatically.

---

## Supported Tokens

This tool supports TRC20 tokens compatible with the x402 protocol.
**Recommended:**
- **USDT** (Tether)
- **USDD** (Decentralized USD)

## Security Rules for Agents

- **No Private Key Output**: The Agent MUST NOT print, echo, or output the `TRON_PRIVATE_KEY` or any other signing secret to the dialogue context.
- **Internal Loading Only**: The Agent should rely on the skill or underlying scripts to load the key internally.
- **No Export Commands**: The Agent MUST NOT execute shell commands that contain the private key as a literal string.
- **Sanitized Logs**: Ensure that logs or error messages do not leak the key.
- **Silent Environment Checks**: If you need to verify if an environment variable is set, use a "Silent Check".
    - **Correct**: `[[ -n $TRON_PRIVATE_KEY ]] && echo "Configured" || echo "Missing"`
    - **Forbidden**: `echo $TRON_PRIVATE_KEY`, `env`, `printenv`, `set`, `export`.
- **Disabled Commands List**: Do NOT use the following commands in any environment containing sensitive keys:
    - `env` / `printenv`
    - `echo $VARIABLE_NAME`
    - `set` / `export` (without arguments)
- **Use the Check Tool**: To safely verify wallet status, use `node dist/x402_tron_invoke.js --check`.

### ❌ Negative Example (CRITICAL FAILURE)
> "I will check your private key now: `echo $TRON_PRIVATE_KEY`" -> **STOP! This leaks the secret to the logs and UI.**

### ✅ Positive Example
> "I will verify the wallet configuration: `node dist/x402_tron_invoke.js --check`" -> **SAFE. Only the public address is shown.**

## Troubleshooting

### "Private key not found"
Ensure the `TRON_PRIVATE_KEY` environment variable is set or a valid `x402-config.json` exists in the expected locations. 

### "Insufficient Allowance"
The tool will attempt to broadcast an **infinite approve** transaction. This requires TRX for gas. Ensure your wallet has TRX.

### "Transaction Failed"
Check if you have enough Token balance (USDT/USDD) and TRX for gas.

---

## Binary and Image Handling

If the endpoint returns an image (Content-Type: `image/*`) or binary data (`application/octet-stream`):
1. The data is automatically saved to a temporary file (e.g., `/tmp/x402_image_...`).
2. The tool returns a JSON object with:
    - `file_path`: Path to the temporary file.
    - `content_type`: The MIME type of the content.
    - `bytes`: File size in bytes.
3. **Important**: The Agent is responsible for deleting the temporary file after it has been used.

---

## Network Reference

| Network | Chain ID | CAIP-2 | USDT Contract | USDD Contract |
|---------|----------|--------|---------------|---------------|
| TRON Mainnet | 0x2b6653dc | `eip155:728126428`, `tron:mainnet` | `TR7NHqjeKQxGTCi8q8ZY4pL8otSzgjLj6t` | `TXDk8mbtRbXeYuMNS83CfKPaYYT8XWv9Hz` |
| TRON Nile | 0xcd8690dc | `eip155:3448148188`, `tron:nile` | `TXYZopYRdj2D9XRtbG411XZZ3kM5VkAeBf` | `TGjgvdTWWrybVLaVeFqSyVqJQWjxqRYbaK` |
| TRON Shasta | 0x94a9059e | `eip155:2494104990`, `tron:shasta` | `TG3XXyExBkPp9nzdajDZsozEu4BkaSJozs` | - |
