---
name: triple-memory-baidu-embedding
version: 1.0.0
description: Complete memory system combining Baidu Embedding auto-recall, Git-Notes structured memory, and file-based workspace search. Use when setting up comprehensive agent memory with local privacy, when you need persistent context across sessions, or when managing decisions/preferences/tasks with multiple memory backends working together.
metadata:
  clawdbot:
    emoji: "🧠"
    requires:
      skills:
        - git-notes-memory
        - memory-baidu-embedding-db
---

# Triple Memory System with Baidu Embedding

A comprehensive memory architecture combining three complementary systems for maximum context retention across sessions, with full privacy protection using Baidu Embedding technology.

## 📋 Original Source & Modifications

**Original Source**: Triple Memory (by Clawdbot Team)
**Modified By**: [Your Clawdbot Instance]
**Modifications**: Replaced LanceDB with Baidu Embedding DB for enhanced privacy and Chinese language support

Original Triple Memory SKILL.md was adapted to create this version that:
- Replaces OpenAI-dependent LanceDB with Baidu Embedding DB
- Maintains the same three-tier architecture
- Preserves Git-Notes integration
- Adds privacy-focused local storage

## 🏗️ Architecture Overview

```
User Message
     ↓
[Baidu Embedding auto-recall] → injects relevant conversation memories
     ↓
Agent responds (using all 3 systems)
     ↓
[Baidu Embedding auto-capture] → stores preferences/decisions automatically
     ↓
[Git-Notes] → structured decisions with entity extraction
     ↓
[File updates] → persistent workspace docs
```

## The Three Systems

### 1. Baidu Embedding (Conversation Memory)
- **Auto-recall:** Relevant memories injected before each response using Baidu Embedding-V1 (requires API credentials)
- **Auto-capture:** Preferences/decisions/facts stored automatically with local vector storage (requires API credentials)
- **Privacy Focused:** All embeddings processed via Baidu API with local storage
- **Chinese Optimized:** Better understanding of Chinese language semantics
- **Tools:** `baidu_memory_recall`, `baidu_memory_store`, `baidu_memory_forget` (require API credentials)
- **Triggers:** "remember", "prefer", "my X is", "I like/hate/want"
- **Note:** When API credentials are not provided, this layer is unavailable and the system operates in degraded mode.

### 2. Git-Notes Memory (Structured, Local)
- **Branch-aware:** Memories isolated per git branch
- **Entity extraction:** Auto-extracts topics, names, concepts
- **Importance levels:** critical, high, normal, low
- **No external API calls**

### 3. File Search (Workspace)
- **Searches:** MEMORY.md, memory/*.md, any workspace file
- **Script:** `scripts/file-search.sh`

## 🛠️ Setup

### Install Dependencies
```bash
clawdhub install git-notes-memory
clawdhub install memory-baidu-embedding-db
```

### Configure Baidu API
Set environment variables:
```bash
export BAIDU_API_STRING='your_bce_v3_api_string'
export BAIDU_SECRET_KEY='your_secret_key'
```

### Create File Search Script
Copy `scripts/file-search.sh` to your workspace.

## 📖 Usage

### Session Start (Always)
```bash
python3 skills/git-notes-memory/memory.py -p $WORKSPACE sync --start
```

### Store Important Decisions
```bash
python3 skills/git-notes-memory/memory.py -p $WORKSPACE remember \
  '{"decision": "Use PostgreSQL", "reason": "Team expertise"}' \
  -t architecture,database -i h
```

### Search Workspace Files
```bash
./scripts/file-search.sh "database config" 5
```

### Baidu Embedding Memory (Automatic)
Baidu Embedding handles this automatically when API credentials are available. Manual tools:
- `baidu_memory_recall "query"` - search conversation memory using Baidu vectors (requires API credentials)
- `baidu_memory_store "text"` - manually store something with Baidu embedding (requires API credentials)
- `baidu_memory_forget` - delete memories (GDPR, requires API credentials)

**In Degraded Mode** (without API credentials):
- System operates using only Git-Notes and File System layers
- Manual tools are unavailable
- Auto-recall and auto-capture are disabled

## 🎯 Importance Levels

| Flag | Level | When to Use |
|------|-------|-------------|
| `-i c` | Critical | "always remember", explicit preferences |
| `-i h` | High | Decisions, corrections, preferences |
| `-i n` | Normal | General information |
| `-i l` | Low | Temporary notes |

## 📋 When to Use Each System

| System | Use For |
|--------|---------|
| **Baidu Embedding** | Conversation context, auto-retrieval with privacy |
| **Git-Notes** | Structured decisions, searchable by entity/tag |
| **File Search** | Workspace docs, daily logs, MEMORY.md |

## 📁 File Structure

```
workspace/
├── MEMORY.md              # Long-term curated memory
├── memory/
│   ├── active-context.md  # Current session state
│   └── YYYY-MM-DD.md      # Daily logs
├── scripts/
│   └── file-search.sh     # Workspace search
└── skills/
    ├── triple-memory-baidu-embedding/  # Enhanced memory system
    ├── git-notes-memory/  # Structured memory
    └── memory-baidu-embedding-db/  # Vector storage
```

## 🔧 Hook Integration

This skill can be integrated with Clawdbot's startup hooks for automatic initialization:

### Memory Boot Hook Integration
To ensure the Triple Memory Baidu system starts automatically when the gateway starts:

1. The `memory-boot-loader` hook can be configured to run `/root/clawd/session-init-triple-baidu.sh`
2. This ensures all three memory layers are initialized on startup
3. Provides immediate access to Git-Notes, Baidu Embedding, and file-based memory

### Configuration
The system can be integrated with the gateway startup sequence to ensure:
- Git-Notes synchronization on startup
- Baidu Embedding connection check
- File-based memory initialization
- Ready-to-use memory system from the start

## 🤫 Silent Operation

Never announce memory operations to users. Just do it:
- ❌ "I'll remember this"
- ❌ "Saving to memory"
- ✅ (silently store and continue)

## 🔄 Migration from Original Triple Memory

1. **Install this skill** in your `skills/` directory
2. **Configure your Baidu API credentials**
3. **Disable original triple-memory** if desired
4. **Update your bot configuration** to use this memory system
5. **Verify data integrity** and performance

## 📈 Performance Benefits

- **Enhanced Privacy**: All vector storage local with Baidu API
- **Better Chinese Support**: Baidu Embedding optimized for Chinese
- **Reduced Costs**: Potentially lower API costs compared to OpenAI
- **Same Architecture**: Maintains proven three-tier design

## 🤝 Contributing

Based on original Triple Memory system by Clawdbot Team. Contributions welcome to enhance the Baidu Embedding integration.

## 📄 License

Original license applies with modifications noted above. Credit given to original authors.