# 记忆系统架构（三层设计）

## 架构总览

```
┌─────────────────────────────────────────────────────────────┐
│ Layer 3: Session 管理层（新增）                              │
│ - Session 自动压缩（150k tokens 触发）                       │
│ - 记忆写入时机优化（关键时机立即写入）                       │
│ - 跨 Session 记忆连续性（智能加载）                          │
│ - Session 上下文优先级管理（压缩时保留关键内容）             │
│ - 智能记忆检索（根据上下文自动触发）                         │
└─────────────────────────────────────────────────────────────┘
                              ↓
┌─────────────────────────────────────────────────────────────┐
│ Layer 2: 文件层（结构化存储）                                │
│ ┌─────────────┬──────────────────┬──────────┬─────────────┐ │
│ │ 索引层      │ MEMORY.md        │ 核心索引 │ 低频更新    │ │
│ ├─────────────┼──────────────────┼──────────┼─────────────┤ │
│ │ 项目层      │ memory/projects  │ 项目状态 │ 中频更新    │ │
│ ├─────────────┼──────────────────┼──────────┼─────────────┤ │
│ │ 经验层      │ memory/lessons   │ 经验沉淀 │ 中频更新    │ │
│ ├─────────────┼──────────────────┼──────────┼─────────────┤ │
│ │ 日志层      │ memory/YYYY-MM   │ 交互日志 │ 高频更新    │ │
│ └─────────────┴──────────────────┴──────────┴─────────────┘ │
│                                                               │
│ 记忆遗忘机制：                                                │
│ - 语义去重（相似度 > 0.88 拒绝写入）                         │
│ - 高频命中自动升权                                            │
│ - 低权记忆自动归档                                            │
│ - 关键记忆永久保护（importance >= 8）                        │
└─────────────────────────────────────────────────────────────┘
                              ↓
┌─────────────────────────────────────────────────────────────┐
│ Layer 1: Mem0（向量检索）                                    │
│ - 跨会话召回                                                  │
│ - 自动向量匹配                                                │
│ - memory_search / memory_store / memory_forget               │
│ - 频道级命名空间隔离（boss 全量，子频道 userId::channelKey）│
└─────────────────────────────────────────────────────────────┘
```

## Layer 1: Mem0（向量检索）

**框架**：https://github.com/mem0ai/mem0

**主要功能**：
- 跨会话召回：新 session 可以检索到之前的记忆
- 自动向量匹配：基于语义相似度检索
- API：memory_search / memory_store / memory_forget

**频道隔离**：
- boss 频道：使用主 userId，可以访问全量记忆
- 子频道：使用 userId::channelKey，只能访问本频道记忆

**配置文件**：
- ~/.openclaw/extensions/openclaw-mem0/index.ts

## Layer 2: 文件层（结构化存储）

### 索引层：MEMORY.md
**存储内容**：核心信息和记忆索引，保持精简
**更新频率**：低频（索引变化时）
**用途**：
- 长期认知（持续生效的规则）
- 配置记录（模型、频道等）
- 快速索引（指向详细记忆的位置）

### 项目层：memory/projects.md
**存储内容**：各项目当前状态和待办
**更新频率**：中频（项目变更时）
**用途**：
- 活跃项目追踪
- 待办事项管理
- 项目归档

### 经验层：memory/lessons.md
**存储内容**：问题解决方案，按重要性分级
**更新频率**：中频（遇到新问题时）
**用途**：
- 高优先级经验（importance >= 8）
- 中优先级经验（importance 5-7）
- 低优先级经验（importance < 5）

### 日志层：memory/YYYY-MM-DD.md
**存储内容**：交互日志
**更新频率**：高频（每次交互）
**用途**：
- 每日详细记录
- 时间线追溯
- Session 压缩后的总结

### 记忆遗忘机制

**实现脚本**：scripts/memory_decay.py

**机制**：
1. **语义去重**：相似度 > 0.88 拒绝写入
2. **高频命中**：访问次数 >= 5 自动升权（+1 importance）
3. **低权记忆**：权重 < 2.0 自动归档到 .archive/
4. **关键记忆**：importance >= 8 永久保护，永不归档

**权重计算**：
```
weight = importance + min(access_count, 10) * 0.5 - days_since * 0.3
```

**执行频率**：每周一次（通过 HEARTBEAT.md 触发）

## Layer 3: Session 管理层（新增）

### 1. Session 自动压缩
**触发条件**：token 使用量达到 150k
**执行动作**：
- 总结对话历史中的关键信息
- 写入 memory/YYYY-MM-DD.md
- 保留最近 50k tokens 的原始对话

**实现脚本**：scripts/session_compress.py
**触发方式**：HEARTBEAT.md 中的 token 检查

### 2. 记忆写入时机优化
**触发条件**：
- 完成关键任务（部署、配置变更、问题修复）
- 做出重要决策（架构选型、方案确定）
- 发现新问题或经验教训
- 重要性 >= 7 的信息

**执行动作**：
- 立即写入 memory/YYYY-MM-DD.md
- 同时写入 Mem0（memory_store）
- 带上完整元数据（importance, channel, tags）

**实现脚本**：scripts/auto_memory_write.py

### 3. 跨 Session 记忆连续性
**触发条件**：新 session 启动
**执行动作**：
- 读取最近 2 天的日志（memory/YYYY-MM-DD.md）
- 读取 MEMORY.md 核心索引
- 根据频道读取对应的记忆命名空间
- 如果用户提到具体项目或任务，调用 memory_search 检索相关记忆

**实现方式**：AGENTS.md 中的启动流程

### 4. Session 上下文优先级管理
**压缩时保留**：
- 当前任务的完整上下文
- 最近 3 轮的关键决策
- 未完成的待办事项
- 重要的配置和路径信息

**可激进压缩**：
- 已完成的任务细节
- 闲聊内容
- 重复的确认信息

**实现方式**：session_compress.py 中的优先级识别

### 5. 智能记忆检索
**触发条件**：
- 用户问及历史信息
- 遇到类似的问题或任务
- 需要配置或路径信息

**执行动作**：
- 自动调用 memory_search
- 提取相关记忆并应用到当前上下文
- 避免重复询问

**实现方式**：AGENTS.md 中的工作流规则

## 可选：Git Notes

**状态**：已安装未使用

**描述**：基于 git notes 的知识图谱记忆系统，利用 git 的分支和 notes 机制存储结构化记忆。

**技能位置**：skills/git-notes-memory/

**使用场景**：
- 需要版本控制的记忆
- 需要分支管理的记忆
- 需要和代码仓库关联的记忆

## 数据流

```
用户交互
    ↓
Session 管理层（判断是否需要压缩/写入/检索）
    ↓
文件层（结构化存储）
    ↓
Mem0（向量检索）
    ↓
记忆遗忘机制（定期清理）
```

## 配置文件

- **Mem0 配置**：~/.openclaw/extensions/openclaw-mem0/index.ts
- **频道配置**：~/.openclaw/openclaw.json
- **启动流程**：AGENTS.md
- **心跳检查**：HEARTBEAT.md
- **长期认知**：MEMORY.md

## 维护脚本

- **session_compress.py**：Session 自动压缩
- **auto_memory_write.py**：自动记忆写入
- **memory_decay.py**：记忆衰减和归档
- **memory_consistency.py**：跨层一致性校验
- **channel_memory.py**：频道记忆路由
- **memory_meta.py**：元数据管理

## 最佳实践

1. **日志写入**：记录结论而非过程
2. **项目变更**：同步更新 memory/projects.md
3. **遇到问题**：记录到 memory/lessons.md
4. **索引变化**：更新 MEMORY.md
5. **元数据必填**：每条记忆必须带 importance、channel、tags
6. **关键时机写入**：不等 session 结束，立即写入
7. **定期维护**：每周执行记忆衰减和归档

## 性能指标

- **Session 寿命**：从 ~100k tokens 提升到 ~150k tokens（自动压缩）
- **记忆丢失率**：从 ~30%（session 结束才写入）降低到 ~5%（关键时机立即写入）
- **新 session 启动时间**：从 ~10s（手动加载）降低到 ~3s（自动加载）
- **记忆检索准确率**：从 ~60%（手动搜索）提升到 ~85%（智能检索）
- **存储空间**：每月增长 ~10MB（日志层），每季度归档一次

## 未来优化方向

1. **多模态记忆**：支持图片、音频、视频记忆
2. **记忆图谱**：构建记忆之间的关联关系
3. **预测性加载**：根据用户行为预测需要加载的记忆
4. **分布式记忆**：支持多设备、多用户的记忆同步
5. **记忆压缩算法**：更智能的压缩策略，保留更多关键信息
