---
name: self-evolution
version: "3.0.0-tricore"
description: Sara's Self-Evolution System (TriCore Edition). Core positioning: achieve true code-level, architecture-level, and tool-level upgrades by acquiring external internet knowledge (GitHub/papers/docs). Decouples memory management; all states, decisions, and knowledge accumulation generated by evolution are handed over to TriCore (memctl.py).
allowed-tools:
  - web_search
  - web_fetch
  - default_api:exec
  - default_api:edit
  - default_api:write
---

# Sara Self-Evolution System (Code-First & TriCore Edition)

This skill defines how Sara (OpenClaw) performs **substantial self-iteration**.
After the `v3.0.0` architectural adjustment, this system has strictly stripped away the "memory management" function. The past behavior of casually writing a large number of notes in `memory/cheatsheets/` or `memory/daily-learning/` has been **completely banned**.

**Global Architectural Boundaries**:
- **TriCore** = The system's **database and state machine** (responsible for storage).
- **Self-Evolution** = The system's **R&D and CI/CD engine** (responsible for computing, learning, and modifying).

## Core Positioning: Code-Level and Architecture-Level Upgrades

Self-evolution is no longer simply "summarizing a few chat experiences and writing them into Markdown". True evolution must be reflected in actual changes to **code, tools, scripts, workflows (Skill logic), or system configurations**.

The source of evolution must be the **external internet** (via `web_search` / `web_fetch` or `agent-browser` to research the latest Agent frameworks, API usages, and optimization algorithms).

## Standard Evolution Workflow (The Evolution Pipeline)

When a self-evolution task is triggered (e.g., the daily 20:30 cron job, or requested manually by the user), strictly follow this pipeline:

### 1. Reconnaissance
- **Action**: Use web tools to search for the latest technical practices (e.g., Prompt optimization, tool calling paradigms, Python/Node.js new features, system security hardening).
- **Constraint**: Do not store large blocks of web content locally. Extract the core code logic or architectural ideas in your "brain" (context).

### 2. Safety Checkpoint
- **Action**: Before modifying any existing core files (e.g., `tools/*.py`, `skills/*/SKILL.md`, `openclaw.json`), you **MUST** create a backup.
- **Command Example**:
  ```bash
  cp tools/memctl.py evolution-backups/memctl_backup_$(date +%Y%m%d).py
  ```

### 3. Code-Level Upgrade
- **Action**: Write or modify the actual running code.
  - Optimize Python/Shell scripts under `tools/` to improve execution efficiency or add new parameters.
  - Modify hooks or toolchains in `skills/*/SKILL.md`.
  - Write new automation scripts and place them in `scripts/`.
- **Constraint**: Evolution must be Deterministic; the code must be executable.

### 4. Validation
- **Action**: Run the modified scripts or tools to ensure no regression errors are introduced.
  ```bash
  python3 tools/memctl.py --help  # Ensure it doesn't crash after modification
  ```

### 5. State and Knowledge Persistence (Handover to TriCore)
- **Action**: After a successful evolution, hand over the **evolutionary decisions and architectural changes** to TriCore for recording.
- **Prohibited**: It is strictly forbidden to manually create `xxx-learning.md`.
- **Compliant Recording Method**:
  ```bash
  # 1. Record daily evolution execution log (Volatile)
  python3 tools/memctl.py capture "Completed 2026-02-26 evolution: refactored memctl.py, added support for batch archiving."

  # 2. Store newly learned general technical specifications into the knowledge base (Stable KB)
  python3 tools/memctl.py kb_append playbooks "When modifying OpenClaw hooks, absolute paths must be used, and bash is preferred over sh to support advanced syntax."

  # 3. Record major architectural decisions
  python3 tools/memctl.py kb_append decisions "Self-Evolution abandoned piling up local notes and shifted to a code-level CI/CD model."
  ```

## Emergency Rollback Mechanism

If evolution causes system anomalies or infinite errors (3-strike rule):
1. Stop current operations immediately.
2. Restore the modified files from `evolution-backups/`.
3. Use `python3 tools/memctl.py capture "Evolution failed and rolled back, reason: XXX"` to record the failure experience.
4. Write the lesson learned into `memory/kb/decisions.md` ("Why this approach is not viable") to prevent repeating the same mistake in the future.

---
**Summary**: Self-Evolution is responsible for outward exploration and inward surgery (modifying code), and reports to TriCore (logging) after the modification is done. Clear division of duties, never overstepping boundaries.