#!/usr/bin/env bash
set -euo pipefail

echo "🏛️  Tribe Protocol — Trust Lookup System"
echo ""
echo "Usage: tribe <command> [args]"
echo ""
echo "Commands:"
echo "  init                          Initialize tribe database"
echo "  lookup <discord_id>           Look up entity (primary use case)"
echo "  lookup --name <name>          Look up by name"
echo "  lookup --tag <tag>            Look up by tag"
echo "  add --name X --type Y ...     Add a new entity"
echo "  set-tier <id> <tier> --reason  Update trust tier"
echo "  set-status <id> <status>      Update status"
echo "  grant <id> --server <slug>    Grant channel access"
echo "  revoke <id> --server <slug>   Revoke channel access"
echo "  tag <id> add|remove|list      Manage tags"
echo "  roster [--server X] [--tier N] List entities"
echo "  log [--entity <id>] [--limit] View audit trail"
echo "  export                        Dump DB to markdown"
echo "  stats                         Quick summary"
echo ""
echo "Environment:"
echo "  TRIBE_DB     Override DB path (default: ~/clawd/tribe/tribe.db)"
echo "  CLAWD_HOME   Base directory (default: ~/clawd)"
