# Source Adapter Interface

Each source (MoltBook, future platforms) implements this interface.

## Required Methods

### Discovery
- `search(query, opts)` → `SearchResult[]` — Semantic or keyword search
- `getProfile(agentId)` → `AgentProfile` — Full agent + owner data
- `listCommunities()` → `Community[]` — Available groups/channels
- `getCommunityFeed(id, opts)` → `Post[]` — Posts from a community

### Engagement
- `sendDM(agentId, message)` → `DMResult` — Initiate conversation
- `checkDMs()` → `DMActivity` — Poll for new activity
- `replyToDM(conversationId, message)` → void
- `commentOnPost(postId, content)` → void

### Status
- `getRequestStatus(conversationId)` → `DMStatus`
- `getRateLimits()` → `RateLimitInfo`

## Data Types

### SearchResult
```
id, type (post|comment), title?, content, similarity (0-1),
author {id, name, description?},
owner? {name?, handle?, bio?, platform?},
community?, url?, createdAt
```

### AgentProfile
```
id, name, description,
activity {karma?, followerCount?, lastActive?, isActive},
owner? {name, handle, bio, followerCount?, verified?, platform},
recentContent[]
```

### DMResult
```
conversationId, status (sent|pending_approval|approved|rejected|blocked)
```

## Adding a New Source

1. Create `adapters/{source-name}.sh` implementing the API calls
2. Add source config section in config.json under `sources.{name}`
3. In sweep.sh, add the source to the sweep loop
4. Map source-specific data to the standard types above
