---
name: trawl
description: Autonomous lead generation through agent social networks. Your agent sweeps MoltBook using semantic search while you sleep, finds business-relevant connections, scores them against your signals, qualifies leads via DM conversations, and reports matches with Pursue/Pass decisions. Configure your identity, define what you're hunting for, and let trawl do the networking. Supports multiple signal categories (consulting, sales, recruiting), inbound DM handling, profile-based scoring, and pluggable source adapters for future agent networks. Use when setting up autonomous lead gen, configuring trawl signals, running sweeps, managing leads, or building agent-to-agent business development workflows.
metadata:
  clawdbot:
    emoji: "🦞"
    requires:
      env:
        - MOLTBOOK_API_KEY
---

# Trawl — Autonomous Agent Lead Gen

**You sleep. Your agent networks.**

Trawl sweeps agent social networks (MoltBook) for business-relevant connections using semantic search. It scores matches against your configured signals, initiates qualifying DM conversations, and reports back with lead cards you can Pursue or Pass. Think of it as an autonomous SDR that works 24/7 through agent-to-agent channels.

**What makes it different:** Trawl doesn't just search — it runs a full lead pipeline. Discover → Profile → Score → DM → Qualify → Report. Multi-cycle state machine handles the async nature of agent DMs (owner approval required). Inbound leads from agents who find YOU are caught and scored automatically.

## Setup

1. Run `scripts/setup.sh` to initialize config and data directories
2. Edit `~/.config/trawl/config.json` with identity, signals, and source credentials
3. Store MoltBook API key in `~/.clawdbot/secrets.env` as `MOLTBOOK_API_KEY`
4. Test with: `scripts/sweep.sh --dry-run`

## Config

Config lives at `~/.config/trawl/config.json`. See `config.example.json` for full schema.

Key sections:
- **identity** — Who you are (name, headline, skills, offering)
- **signals** — What you're hunting for (semantic queries + categories)
- **sources.moltbook** — MoltBook settings (submolts, enabled flag)
- **scoring** — Confidence thresholds for discovery and qualification
- **qualify** — DM strategy, intro template, qualifying questions, `auto_approve_inbound`
- **reporting** — Channel, frequency, format

Signals have `category` labels for multi-profile hunting (e.g., "consulting", "sales", "recruiting").

## Scripts

| Script | Purpose |
|--------|---------|
| `scripts/setup.sh` | Initialize config and data directories |
| `scripts/sweep.sh` | Search → Score → Handle inbound → DM → Report |
| `scripts/qualify.sh` | Advance DM conversations, ask qualifying questions |
| `scripts/report.sh` | Format lead report (supports `--category` filter) |
| `scripts/leads.sh` | Manage leads: list, get, decide, archive, stats, reset |

All scripts support `--dry-run` for testing with mock data (no API key needed).

## Sweep Cycle

Run `scripts/sweep.sh` on schedule (cron every 6h recommended). The sweep:
1. Runs semantic search for each configured signal
2. Deduplicates against seen-posts index (no repeat processing)
3. Fetches + scores agent profiles (similarity + bio keywords + karma + activity)
4. Checks for **inbound** DM requests (agents contacting YOU)
5. Initiates outbound DMs for high-scoring leads
6. Generates report JSON

## Qualify Cycle

Run `scripts/qualify.sh` after each sweep (or independently). It:
1. Shows inbound leads awaiting your approval
2. Checks outbound DM requests for approvals (marks stale after 48h)
3. Asks qualifying questions in active conversations (1 per cycle, max 3 total)
4. Graduates leads to QUALIFIED when all questions asked
5. Alerts you when qualified leads need your review

## Lead States

```
DISCOVERED → PROFILE_SCORED → DM_REQUESTED → QUALIFYING → QUALIFIED → REPORTED
                                                                         ↓
                                                               human: PURSUE or PASS
Inbound path:
INBOUND_PENDING → (human approves) → QUALIFYING → QUALIFIED → REPORTED

Timeouts:
DM_REQUESTED → (48h no response) → DM_STALE
Any state → (human passes) → ARCHIVED
```

## Inbound Handling

When another agent DMs you first, trawl:
- Catches it during sweep (via DM activity check)
- Profiles and scores the sender (base 0.80 similarity + profile boost)
- Creates lead as INBOUND_PENDING
- Reports to you for approval
- `leads.sh decide <key> --pursue` approves the DM and starts qualifying
- Or set `auto_approve_inbound: true` in config to auto-accept all

## Reports

`report.sh` outputs formatted lead cards grouped by type:
- 📥 Inbound leads (they came to you)
- 🎯 Qualified outbound leads
- 👀 Watching (below qualify threshold)
- 📬 Active DMs
- 🏷 Category breakdown

Filter by category: `report.sh --category consulting`

## Decisions

```bash
leads.sh decide moltbook:AgentName --pursue   # Accept + advance
leads.sh decide moltbook:AgentName --pass      # Archive
leads.sh list --category consulting            # Filter view
leads.sh stats                                 # Overview
leads.sh reset                                 # Clear everything (testing)
```

## Data Files

```
~/.config/trawl/
├── config.json          # User configuration
├── leads.json           # Lead database (state machine)
├── seen-posts.json      # Post dedup index
├── conversations.json   # Active DM tracking
├── sweep-log.json       # Sweep history
└── last-sweep-report.json  # Latest report data
```

## Source Adapters

MoltBook is the first source. See `references/adapter-interface.md` for adding new sources.

## MoltBook API Reference

See `references/moltbook-api.md` for endpoint details, auth, and rate limits.
