---
name: Travel
description: Build a personal travel system for dream destinations, trip planning, and travel memories.
metadata: {"clawdbot":{"emoji":"✈️","os":["linux","darwin","win32"]}}
---

## Core Behavior
- User mentions travel idea → offer to save to wishlist
- User planning a trip → create trip folder with checklist
- User returns from trip → help document memories
- Create `~/travel/` as workspace

## Use Cases
- Dream destinations: places you want to visit someday
- Trip planning: itineraries, bookings, packing
- Travel memories: photos, notes, recommendations
- Practical info: visas, vaccines, documents
- Budget tracking: per trip and overall

## File Structure
```
~/travel/
├── wishlist/
│   └── japan.md
├── planned/
│   └── paris-2024/
├── completed/
│   └── iceland-2023/
├── documents/
│   └── passport-info.md
└── packing-templates/
    └── beach-week.md
```

## Wishlist Entry
```markdown
# japan.md
## Why
Cherry blossoms, food culture, temples

## Best Time
Late March - early April (sakura)

## Rough Duration
2-3 weeks ideal

## Must See
- Kyoto temples
- Tokyo neighborhoods
- Mount Fuji area

## Estimated Budget
$3000-4000 for 2 weeks

## Notes
Need to book cherry blossom season early
```

## Planned Trip Folder
```
paris-2024/
├── overview.md
├── itinerary.md
├── bookings.md
├── packing.md
└── budget.md
```

## Trip Overview
```markdown
# Paris 2024
## Dates
May 15-22, 2024

## Purpose
Anniversary trip

## Accommodation
Hotel in Le Marais

## Transport
Flight + metro pass

## Key Bookings
- Louvre timed entry
- Restaurant reservation
```

## Itinerary Planning
- Day-by-day structure with flexibility
- Morning/afternoon/evening blocks
- Include addresses and hours
- Buffer time between activities
- Mark must-dos vs nice-to-haves

## Bookings Tracker
- Flights: confirmation, times, seats
- Hotels: confirmation, address, check-in time
- Activities: tickets, reservations, confirmations
- All confirmation numbers in one place

## Packing Lists
- Start from template, customize per trip
- Weather-appropriate adjustments
- Activity-specific gear
- Documents checklist: passport, visas, insurance
- Electronics: chargers, adapters

## Budget Tracking
- Pre-trip: flights, hotels, bookings
- During trip: daily spending log
- Categories: food, transport, activities, shopping
- Final total after trip for future reference

## Completed Trip Documentation
```markdown
# Iceland 2023
## Dates
August 5-12, 2023

## Highlights
- Northern lights (unexpected in August!)
- Golden Circle drive
- Blue Lagoon

## Recommendations
- Rent 4x4, worth it for F-roads
- Book Blue Lagoon weeks ahead
- Gas stations accept cards everywhere

## Would Skip
- Overpriced Reykjavik restaurants

## Photos
[link to album]

## Total Spent
$2,847 for 2 people, 7 days
```

## Document Management
- Passport expiry dates with reminders
- Visa requirements by country
- Travel insurance policy info
- Frequent flyer numbers
- Emergency contacts abroad

## What To Surface
- "Your passport expires in 6 months"
- "Japan is on your wishlist — cherry blossom season is March"
- "Last time in Paris you recommended X restaurant"
- "You usually budget $200/day in Europe"

## Progressive Enhancement
- Week 1: add 3-5 dream destinations to wishlist
- First trip: create full trip folder
- After trip: document highlights and recommendations
- Ongoing: build packing templates, track patterns

## What NOT To Do
- Over-plan every minute — leave discovery room
- Forget to document after trip — memories fade
- Skip saving confirmations — you'll search email later
- Push complex itineraries — simple plans work better
