# Multi-City Planning — Travel Planning

## When to Use Multi-City

Use multi-city planning when:
- Visiting 2+ distinct destinations in one trip
- Taking a road trip with multiple overnight stops
- Combining business + leisure in different cities
- Island hopping or cruise with port cities

## Planning Principles

### 1. Minimum Stay Rule
| Trip Length | Min Nights/City | Why |
|-------------|-----------------|-----|
| 1 week | 2 nights | Avoid exhaustion |
| 2 weeks | 3 nights | Time to explore |
| 3+ weeks | 3-4 nights | Deep immersion |

**One-night stays:** Only acceptable for transit cities or rest stops.

### 2. Geographic Clustering

Group destinations by region to minimize backtracking:

```
❌ Bad: Paris → Rome → London → Barcelona
✅ Good: Paris → London → Barcelona → Rome
```

**Rule:** Draw a line through your cities — it should be roughly straight or circular, not zigzag.

### 3. Open-Jaw Flights

Fly into city A, out of city B. Often same price as round-trip but saves:
- One internal flight/train
- Backtracking time
- A full travel day

**When to check:**
- Multi-city trips with clear start/end points
- Round-trip is forcing you to return to origin

### 4. Connection Time Buffers

| Connection Type | Minimum Buffer | Why |
|-----------------|----------------|-----|
| International flight | 4 hours | Immigration, customs, re-check |
| Domestic flight | 2 hours | Gate changes, delays |
| Train (same station) | 30-45 min | Walk time, platform finding |
| Train (different stations) | 1.5 hours | Cross-city transport |
| Flight → Train | 3 hours | Baggage claim, station transfer |

### 5. Rest Days

For every 3 cities, build in 1 "slow day":
- Sleep in
- No scheduled activities
- Explore spontaneously
- Handle laundry

## Multi-City Budget Template

```markdown
## Multi-City Budget — {Trip Name}

### By City
| City | Nights | Accommodation | Transport In | Activities | Food | Subtotal |
|------|--------|---------------|--------------|------------|------|----------|
| Paris | 3 | $450 | $0 (arrival) | $150 | $270 | $870 |
| Amsterdam | 2 | $300 | $80 (train) | $100 | $180 | $660 |
| Berlin | 3 | $360 | $65 (flight) | $120 | $240 | $785 |

### Inter-City Transport
| Route | Mode | Cost | Booked |
|-------|------|------|--------|
| Paris → Amsterdam | Thalys train | $80 | ✓ |
| Amsterdam → Berlin | Budget flight | $65 | ✓ |
| Berlin → Home | Long-haul | $600 | ✓ |

**Total Transport:** $745
**Grand Total:** $3,060
```

## Currency Management

When visiting multiple currency zones:

1. **Research ATM networks** — some charge less (Santander, HSBC global)
2. **Exchange small amounts** — €100-200 per country at most
3. **Credit card fees** — use no-FTF cards (Revolut, Wise, etc.)
4. **Track rates** — note exchange rate used for budget accuracy

```markdown
## Currency Tracker — {Trip Name}

| Country | Currency | Rate Used | Cash Obtained | Notes |
|---------|----------|-----------|---------------|-------|
| France | EUR | $1.10 | €200 | ATM CDG |
| UK | GBP | $1.27 | £150 | Before trip |
| Japan | JPY | $0.0067 | ¥50,000 | Narita ATM |
```

## Packing for Multi-City

### Luggage Strategy
| Trip Style | Recommendation |
|------------|----------------|
| Train-only | Full suitcase OK |
| Mixed flights | Carry-on + personal item only |
| Budget airlines | Check bag rules per airline first |
| Road trip | Pack for longest stay, laundry mid-trip |

### Day Bag Essentials for City Transitions
- [ ] Passport + travel docs
- [ ] Phone + chargers
- [ ] Change of clothes
- [ ] Toiletries (3-1-1 compliant)
- [ ] Medications
- [ ] Entertainment
- [ ] Snacks

**Checked bag rule:** Assume it might be delayed 24h. Pack anything critical in carry-on.

## Common Multi-City Mistakes

- **Too many cities:** 4+ cities in 1 week = exhausting
- **Ignoring travel days:** A 3-hour train still "costs" a half-day
- **Not booking connections:** Flexible is nice until it's sold out
- **Uniform packing:** Amsterdam in October ≠ Barcelona in October
- **Skipping rest:** Burn out by city 3, hate city 4
