# Booking Guide — Travel Planning

## Optimal Booking Windows

| Category | Window | Notes |
|----------|--------|-------|
| **International flights** | 3-4 months | 10-20% savings vs last-minute |
| **Domestic flights** | 6-8 weeks | Price sweet spot |
| **Hotels** | 2-3 months | Best selection + free cancellation |
| **Rental cars** | 2-6 weeks | Prices stable, rebook if drops |
| **Activities/tours** | 2-4 weeks | Popular ones sell out earlier |
| **Restaurants** | 1-4 weeks | Fine dining needs more lead time |

## Day-of-Week Pricing

- **Flights:** Tuesday 3pm typically lowest demand
- **Hotels:** Avoid weekend bookings (10-15% weekend premium on rates)
- **Rental cars:** Weekday pickup/return cheaper than weekend

## Seasonal Intelligence

### Shoulder Season (30-40% savings)
- **Europe:** April-May, September-October
- **Asia:** March-April, October-November
- **Americas:** March-April, September-November

### Peak Season Markup (80-120%)
- **Europe:** June-August, Christmas
- **Asia:** Chinese New Year, Golden Week
- **Americas:** Summer, spring break, holidays

### Watch Out For
- Local holidays affect domestic pricing significantly
- Weather backup plans for outdoor activities
- Events/conferences spike hotel prices locally

## Money-Saving Tactics

### Flights
- Flexible dates: +/- 3 days can save 20-40%
- Nearby airports: often 30%+ cheaper
- Split bookings: sometimes cheaper than round-trip
- Points/miles: check before booking cash

### Hotels
- Direct booking: often matches OTA + better perks
- Loyalty rates: 10-15% off for members (free to join)
- Prepaid rates: 15-20% off but non-refundable
- Extended stay: many offer 5th/7th night free

### Rental Cars
- **Avoid airport pickup:** 30-40% markup
- Return same location: one-way fees are brutal
- Check credit card coverage before buying insurance
- Rebook if price drops (most are free cancellation)

### Currency
- Exchange only 20% before departure
- ATMs usually better rates than exchange offices
- Avoid airport exchange: 5-8% worse rates
- Notify bank 7+ days before departure

## Visa Timeline

| Complexity | Lead Time | Examples |
|------------|-----------|----------|
| No visa / e-visa | 1-2 weeks | EU (for some), ESTA, eTA |
| Standard tourist | 30-45 days | Most countries |
| Complex | 90+ days | China, Russia, India, Brazil |
| Passport renewal | 6-8 weeks | Routine processing |

### Passport Validity Rule
Many countries require **6 months validity beyond travel dates**. Check before booking.

## Insurance Timing

- **Within 14 days of first deposit:** Full coverage including pre-existing conditions
- **After 14 days:** May exclude pre-existing conditions
- **Cost:** 4-6% of trip cost (adventure coverage adds 2-4%)

## Confirmation Checklist

Save immediately in `bookings.md`:
- Confirmation numbers
- Dates and times
- Addresses
- Contact numbers
- Cancellation policies
- Payment method used

Print or screenshot essential confirmations — don't rely on email access abroad.
