# Travel Research Checklist

Use this checklist before finalizing any itinerary. Mark each item as complete with source + check date.

## Core Inputs

- Destination confirmed
- Absolute start/end dates confirmed (`YYYY-MM-DD`)
- Origin city confirmed (if cross-city travel needed)
- Travelers count + trip style confirmed
- Budget level + key constraints confirmed

## Time-Sensitive Checks (Must Verify)

1. Weather and seasonal risk
- 7-14 day forecast (if available)
- Typical temperature range and precipitation
- Extreme weather advisories (storm, heatwave, snow, etc.)

2. Attraction and experience availability
- Official opening hours
- Temporary closures or renovation periods
- Reservation windows and sold-out risk

3. Transportation reliability
- Flight/train/ferry timetable on travel dates
- First/last departure for key routes
- Transfer duration and late-night alternatives

4. Entry policy and documentation
- Visa or visa-waiver requirements
- Passport/ID validity requirements
- Any current border-entry advisories

5. Demand and pricing spikes
- Local festivals/conferences/holidays
- Hotel occupancy pressure and price surge risk
- Crowd intensity by area/time

## Source Priority

Prefer primary sources in this order:

1. Official operator/venue/government websites
2. Official tourism boards
3. Reputable aggregators (cross-check with primary source)

Avoid relying on old blog posts for schedule-critical details.

## Minimum Verification Log Fields

- Item checked
- Source URL
- Checked date
- Result summary
- Action needed

## Delivery Gate

Do not present uncertain details as confirmed facts.
When uncertain, label explicitly: "needs reconfirmation".
