# Output Specification

Use this rubric to ensure the final itinerary is complete and image-rich.

## Required Sections

1. Trip Snapshot
- Destination
- Dates and trip length
- Origin
- Travelers
- Budget level
- Pace and focus

2. Cover Visual
- One top-level image
- Clear caption relevance

3. Executive Summary
- Route logic and sequencing rationale
- Top booking constraints
- Highest-risk assumptions

4. Day-by-Day Plan
- One block per day
- Morning/afternoon/evening structure
- Transfer note for each day
- Reservation-required activities flagged
- Rain/backup option included

5. Transportation Plan
- Inbound and outbound options
- Local movement strategy
- Map links for key anchors

6. Accommodation Guidance
- 2-3 recommended areas
- Cost range and convenience tradeoffs
- Safety and late-night access notes

7. Budget Table
- Per-person/day cost estimate by category
- Whole-trip estimate for full party
- Explicit note for excluded items (for example long-haul flight)

8. Booking Timeline
- T-30 to T-14
- T-14 to T-7
- T-3 to T-1
- Departure-day checks

9. Risk and Contingency
- Weather fallback
- Transport fallback
- Health/safety fallback

10. Image Gallery
- At least 3 relevant images
- Captions or context labels

11. Verification Log
- Source + checked date for each time-sensitive fact
- Remaining open items listed

## Quality Bar

- Feasibility: route and daily load are realistic
- Specificity: no generic filler where concrete detail is available
- Transparency: unknowns are clearly labeled
- Readability: section order supports real-world execution

## Common Failure Modes

- Over-packed days with ignored transfer time
- No explicit booking deadlines
- Budgets disconnected from trip length or traveler count
- Missing source trace for dynamic facts
