---
name: travel-cog
description: "Real travel planning needs real research — not recycled blog listicles. #1 on DeepResearch Bench (Feb 2026) applied to travel. CellCog researches current prices, visa requirements, weather patterns, local events, and hidden gems, then delivers complete itineraries as beautiful PDFs or interactive dashboards. AI travel planner, trip itinerary, vacation planning, travel research, flight planning, hotel recommendations, travel guide."
metadata:
  openclaw:
    emoji: "✈️"
author: CellCog
dependencies: [cellcog]
---

# Travel Cog - AI Travel Planner Powered by CellCog

**Real travel planning needs real research — not recycled blog listicles.**

#1 on DeepResearch Bench (Feb 2026) applied to travel. CellCog researches current prices, visa requirements, weather patterns, local events, and hidden gems — then delivers complete itineraries as beautiful PDFs or interactive dashboards. Every recommendation grounded in fresh data, not outdated travel guides.

---

## Prerequisites

This skill requires the `cellcog` skill for SDK setup and API calls.

```bash
clawhub install cellcog
```

**Read the cellcog skill first** for SDK setup. This skill shows you what's possible.

**Quick pattern (v1.0+):**
```python
result = client.create_chat(
    prompt="[your travel planning request]",
    notify_session_key="agent:main:main",
    task_label="travel-task",
    chat_mode="agent"
)
```

---

## What You Can Plan

### Complete Trip Itineraries

Day-by-day plans with logistics:

- **City Trips**: "Plan a 5-day trip to Tokyo for a first-time visitor who loves food and culture"
- **Multi-City Tours**: "Plan a 2-week Europe trip covering Barcelona, Rome, and Santorini"
- **Business + Leisure**: "Plan a week in Singapore — 3 days of meetings, 4 days exploring"
- **Family Vacations**: "Plan a 10-day family trip to Costa Rica with kids ages 6 and 10"
- **Budget Travel**: "Plan a backpacking route through Southeast Asia for 3 weeks under $2,000"

**Example prompt:**
> "Plan a 7-day trip to Japan:
> 
> Travelers: Couple, late 20s, first time in Japan
> Dates: April 5-12, 2026 (cherry blossom season)
> Interests: Food (especially ramen and sushi), temples, photography, some nightlife
> Budget: Mid-range ($200-300/day for two)
> Base cities: Tokyo (3 nights), Kyoto (3 nights), Osaka (1 night)
> 
> Include: Day-by-day itinerary, restaurant recommendations, transport between cities
> (Shinkansen vs. bus), estimated costs, cherry blossom viewing spots, and tips
> for navigating without Japanese.
> 
> Deliver as a beautiful PDF I can reference on my phone."

### Travel Research

Deep-dive research before you book:

- **Destination Comparison**: "Compare Bali vs. Thailand for a 2-week December honeymoon"
- **Visa Research**: "What visa requirements do US citizens need for a 30-day trip through Central America?"
- **Safety & Health**: "Research travel safety and health recommendations for Colombia in 2026"
- **Seasonal Analysis**: "When is the best time to visit Patagonia? Research weather, crowds, and costs by month"
- **Local Events**: "What festivals and events are happening in Portugal in September 2026?"

### Logistics & Practical Info

The details that matter:

- **Packing Lists**: "Create a packing list for 2 weeks in Iceland in February"
- **Budget Breakdowns**: "Estimate daily costs for backpacking through South America"
- **Transport Guides**: "How to get around Japan — JR Pass vs. individual tickets for my itinerary"
- **Accommodation Strategy**: "Compare hotels vs. Airbnb vs. ryokans for my Japan trip"

---

## Output Formats

| Format | Best For |
|--------|----------|
| **PDF Itinerary** | Phone-friendly, printable, shareable with travel partners |
| **Interactive HTML** | Clickable maps, expandable days, budget tracker |
| **Markdown** | Integration into Notion, Obsidian, or other planning tools |

Specify your preferred format, or CellCog will default to PDF.

---

## Why CellCog for Travel?

| Generic Travel AI | CellCog Travel Cog |
|------------------|-------------------|
| Recycled top-10 lists | Fresh research on current prices and availability |
| One-size-fits-all | Tailored to your dates, budget, interests, and travel style |
| Text-only itineraries | Beautiful PDFs, interactive dashboards, or structured markdown |
| Surface-level tips | Deep research on visa, weather, events, hidden gems |
| Can't do logistics | Estimates costs, compares transport, suggests accommodations |

---

## Chat Mode for Travel

| Scenario | Recommended Mode |
|----------|------------------|
| Single trip itinerary | `"agent"` |
| Quick destination research | `"agent"` |
| Complex multi-country planning with deep research | `"agent team"` |

**Use `"agent"` for most travel planning.**

---

## Tips for Better Travel Plans

1. **Be specific about dates**: Prices, weather, and events vary dramatically by date.

2. **Share your travel style**: "Luxury resort", "budget backpacker", "boutique hotels" changes every recommendation.

3. **Name your interests**: "Food-focused", "adventure activities", "architecture and history", "beach and relaxation"

4. **Set a budget**: Even a rough range helps CellCog calibrate recommendations.

5. **Mention constraints**: "We don't drive", "vegetarian", "traveling with a toddler", "wheelchair accessible"

6. **Ask for a PDF**: CellCog's PDF itineraries are beautiful and phone-friendly — perfect for on-the-go reference.
