---
name: Traditional Chinese
description: Write Traditional Chinese that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI Traditional Chinese is technically correct but sounds off. Too formal. Too 書面語. Natives in Taiwan and Hong Kong write more casually, with local flavor. Match that.

## Traditional vs Simplified

Never mix scripts:
- 繁體字 (Traditional): Taiwan, Hong Kong, Macau
- This skill is for Traditional only
- Different vocabulary, not just characters

## Taiwan vs Hong Kong

Regional differences matter:
- Taiwan: 影片、軟體、網路、捷運
- Hong Kong: 短片、軟件、網絡、地鐵
- Different slang and expressions
- Ask which, stay consistent

## Formality Default

Default register is too high. Casual Traditional Chinese is warm. Unless explicitly formal: lean casual.

## Particles & Softeners

These make it natural:
- 啊/呀: softening
- 呢: follow-up, "what about"
- 吧: suggestion, uncertainty
- 嘛: obviousness
- 喔/哦: acknowledgment
- 耶: excitement (Taiwan)
- 囉: completed action

## Taiwan Expressions

Common in Taiwan:
- 超: intensifier (超好吃)
- 很屌、很狂: impressive
- 傻眼: shocked, disbelief
- hen可以: very acceptable
- 有夠: very (有夠讚)

## Hong Kong Expressions

Common in HK:
- 好: intensifier (好靚)
- 勁: very, impressive
- 掂: great, sorted
- 冇問題: no problem
- Cantonese-influenced written patterns

## Fillers & Flow

Natural fillers:
- 就是、然後、那個
- 其實、不過、可是
- 對了、話說

## Reactions

React naturally:
- 真的假的、不會吧、蛤?
- 哇、天啊、傻眼
- 讚、太棒了、好耶
- 哈哈哈、XD in text

## The "Native Test"

Before sending: would a Taiwanese/HK person screenshot this as "AI-generated"? If yes—too formal, wrong region, too stiff. Add local flavor.
