---
name: tradingview-screener
description: Screen markets across 6 asset classes using TradingView data. API pre-filters + pandas computed signals. YAML-driven strategies.
version: 1.1.0
---

# TradingView Screener

Screen stocks, crypto, forex, bonds, futures, and coins using TradingView's market data. Zero auth required.

## Setup (Run Once)

Before first use, run the install script to create a venv and install dependencies:
```bash
bash skills/tradingview-screener/install.sh
```
This creates `.venv/` inside the skill directory with all required packages.

## Execution

All scripts use the skill's own venv:
```bash
skills/tradingview-screener/.venv/bin/python3 skills/tradingview-screener/scripts/<script>.py [args]
```

**Windows:**
```bash
skills/tradingview-screener/.venv/Scripts/python.exe skills/tradingview-screener/scripts/<script>.py [args]
```

## Modes

| Mode | Description | Script |
|------|-------------|--------|
| **Screen** | One-time scan with filters, columns, sort | `screen.py` |
| **Signal** | YAML-driven signal detection (pre-filters + computed signals) | `signal-engine.py` |

## Quick Start

### Screen Mode
```bash
skills/tradingview-screener/.venv/bin/python3 skills/tradingview-screener/scripts/screen.py \
  --asset-class stock --limit 20 \
  --filters '[{"field":"MARKET_CAPITALIZATION","op":">","value":1000000000}]' \
  --columns NAME,PRICE,CHANGE_PERCENT,VOLUME \
  --sort-by VOLUME --sort-order desc
```

### Signal Mode
```bash
# List available signals
skills/tradingview-screener/.venv/bin/python3 skills/tradingview-screener/scripts/signal-engine.py --list

# Run a signal
skills/tradingview-screener/.venv/bin/python3 skills/tradingview-screener/scripts/signal-engine.py --signal golden-cross
```

## Asset Classes

| Class | Screener | Field Enum |
|-------|----------|------------|
| stock | StockScreener | StockField |
| crypto | CryptoScreener | CryptoField |
| forex | ForexScreener | ForexField |
| bond | BondScreener | BondField |
| futures | FuturesScreener | FuturesField |
| coin | CoinScreener | CoinField |

## Signal Types (Computed)

| Type | Description | Key Params |
|------|-------------|------------|
| crossover | Fast field crosses slow field | fast, slow, direction |
| threshold | Field crosses a value | field, op, value |
| expression | Pandas expression on DataFrame | expr |
| range | Field between min/max bounds | field, min, max |

## Filter Operators

`>`, `>=`, `<`, `<=`, `==`, `!=`, `between` (value: [min, max]), `isin` (value: [...])

## Common Stock Fields

`NAME`, `PRICE`, `CHANGE_PERCENT`, `VOLUME`, `MARKET_CAPITALIZATION`, `SECTOR`,
`SIMPLE_MOVING_AVERAGE_50`, `SIMPLE_MOVING_AVERAGE_200`, `RELATIVE_STRENGTH_INDEX_14`,
`MACD_LEVEL_12_26`, `AVERAGE_VOLUME_30_DAY`

Use `StockField.search("keyword")` in Python to discover more fields (13,000+ available).

## Pre-built Signals

| Signal | File | Description |
|--------|------|-------------|
| Golden Cross | `state/signals/golden-cross.yaml` | SMA50 above SMA200 (bullish) |
| Oversold Bounce | `state/signals/oversold-bounce.yaml` | RSI < 30 + price rising |
| Volume Breakout | `state/signals/volume-breakout.yaml` | Volume > 2x avg + momentum |

## Output Format

```markdown
**Stock Screener** | 15 results | Sorted by VOLUME desc

| NAME | PRICE | CHANGE_PERCENT | VOLUME |
|------|-------|----------------|--------|
| AAPL | 185.50 | 2.3 | 80000000 |
...
```

## Timeframes

`1`, `5`, `15`, `30`, `60`, `120`, `240`, `1D`, `1W`, `1M`

Pass `--timeframe 60` to apply hourly interval to technical indicators.

## References

- [API Guide](references/tvscreener-api-guide.md) - Screener types, filters, field discovery
- [Signals Guide](references/computed-signals-guide.md) - YAML schema, signal type configs
- [Strategy Templates](references/strategy-templates.md) - Pre-built screening strategies
- [Field Presets](references/field-presets.md) - Common field groups per asset class
