# US Stock Practical Examples

## Case 1: Smart Stock Screening - Tech Sector

**User Request**:
```
"Help me screen for strong momentum stocks in the US tech sector"
```

**Skill Execution Process**:

1. Get tech sector candidate pool (200 stocks)
2. Technical analysis filtering (RSI, MACD, trend)
3. Comprehensive scoring and ranking
4. Return Top 10

**Output Result**:
```markdown
# Smart Stock Screening Results - US Tech Sector

## Qualified Stocks (10 total)

### 1. NVIDIA (NVDA) ⭐⭐⭐⭐⭐
**Comprehensive Score**: 94/100

**Technical Analysis**:
- Trend: Strong uptrend 📈
- RSI(14): 67.8 (healthy range)
- MACD: Golden cross day 5, strong momentum
- Volume: 2.3x average volume
- Support: $875.00
- Resistance: $950.00

**Fundamental Highlights**:
- Market Cap: $2.15T
- P/E: 65.3 (growth premium)
- ROE: 123.5%
- Sector: AI/Semiconductors

**Buy Recommendation**: ✅ Strong Buy
- Suggested entry: $890.00-900.00
- Target price: $980.00
- Stop loss: $860.00
- Position size: 10-15%

---

### 2. Microsoft (MSFT) ⭐⭐⭐⭐
**Comprehensive Score**: 89/100

**Technical Analysis**:
- Trend: Steady uptrend 📈
- RSI(14): 62.4 (healthy range)
- MACD: Bullish momentum
- Volume: 1.8x average volume
- Support: $415.00
- Resistance: $445.00

**Fundamental Highlights**:
- Market Cap: $3.08T
- P/E: 35.2 (reasonable)
- ROE: 42.8%
- Sector: Cloud/AI/Software

**Buy Recommendation**: ✅ Buy
- Suggested entry: $425.00-430.00
- Target price: $460.00
- Stop loss: $410.00
- Position size: 10-12%

---

### 3. Advanced Micro Devices (AMD) ⭐⭐⭐⭐
**Comprehensive Score**: 86/100

**Technical Analysis**:
- Trend: Recovery uptrend 📈
- RSI(14): 58.9 (neutral-bullish)
- MACD: Turning positive
- Volume: 1.9x average volume
- Support: $145.00
- Resistance: $165.00

**Fundamental Highlights**:
- Market Cap: $245B
- P/E: 48.5 (growth)
- ROE: 15.3%
- Sector: Semiconductors/AI

**Buy Recommendation**: ✅ Buy
- Suggested entry: $152.00-155.00
- Target price: $175.00
- Stop loss: $142.00
- Position size: 8-10%
```

---

## Case 2: Pattern Recognition - SPY (S&P 500 ETF)

**User Request**:
```
"Analyze the technical pattern for SPY"
```

**Output Result**:
```markdown
# SPY Technical Pattern Analysis

## Identified Patterns

### 🔍 Bull Flag (Confidence: 82%)
- Flagpole: $505 → $525 (strong rally)
- Flag consolidation: $520-$525
- Current position: Mid-flag range
- Duration: 8 trading days

## Trading Strategies

### Strategy A: Breakout Long
- Entry: Break above $525.50
- Target: $540.00
- Stop loss: $518.00
- Risk/Reward: 1:2.0
- Position size: 15-20%

### Strategy B: Support Bounce
- Entry: Bounce at $520.00
- Target: $532.00
- Stop loss: $516.00
- Risk/Reward: 1:3.0
- Position size: 10-15%

## Key Levels
- Strong resistance: $525.50
- Support zone: $520.00-$522.00
- Major support: $515.00
- Volume profile: High volume at $522

## Market Context
- VIX: 14.2 (low volatility)
- Breadth: 65% stocks above 50-day MA
- Sector rotation: Tech leading
```

---

## Case 3: Market Review

**User Request**:
```
"Generate today's US market review report"
```

**Output Result**:
```markdown
# US Market Review - March 2, 2026

## Market Overview
- S&P 500: 5,234.56 (+0.8%)
- Nasdaq: 16,543.21 (+1.2%)
- Dow Jones: 39,876.45 (+0.5%)
- Russell 2000: 2,145.67 (+0.3%)

## Market Internals
- Advance/Decline: 2,845 : 1,234 (2.3:1)
- New Highs/Lows: 234 : 45
- Volume: Above 20-day average (+12%)
- VIX: 14.2 (-5.3%)

## Hot Sectors
1. Technology (+1.5%) - AI momentum continues
2. Communication Services (+1.2%) - Strong earnings
3. Consumer Discretionary (+0.9%) - Retail strength

## Weak Sectors
1. Energy (-0.8%) - Oil price pressure
2. Utilities (-0.5%) - Rate concerns
3. Real Estate (-0.3%) - Yield competition

## Key Movers

### Top Gainers
- NVDA: +3.2% (AI chip demand)
- META: +2.8% (Ad revenue beat)
- TSLA: +2.5% (Delivery numbers)

### Top Losers
- XOM: -2.1% (Oil price drop)
- CVX: -1.8% (Sector weakness)
- NEE: -1.5% (Utility selloff)

## Market Sentiment
- Fear & Greed Index: 68 (Greed)
- Put/Call Ratio: 0.72 (Bullish)
- AAII Bull%: 45.2% (Above average)

## Tomorrow's Watch List
- FOMC Minutes release (2:00 PM ET)
- Jobless claims data (8:30 AM ET)
- Tech earnings: ORCL, CRM

## Trading Strategy
**Bias**: Cautiously bullish
- Focus on tech leaders with momentum
- Watch for FOMC reaction
- Keep stops tight given extended levels
```

---

## Case 4: Options Strategy - AAPL

**User Request**:
```
"Suggest an options strategy for AAPL with moderate bullish outlook"
```

**Output Result**:
```markdown
# AAPL Options Strategy Analysis

## Current Market Data
- Stock Price: $178.50
- IV Rank: 32% (moderate)
- Earnings: 28 days away
- Trend: Consolidating after rally

## Recommended Strategy: Bull Call Spread

### Setup
- Buy: 180 Call @ $4.20
- Sell: 190 Call @ $1.50
- Net Debit: $2.70 per spread
- Expiration: 45 DTE (April 18, 2026)

### Risk/Reward Profile
- Max Profit: $7.30 ($730 per spread)
- Max Loss: $2.70 ($270 per spread)
- Breakeven: $182.70
- Risk/Reward: 1:2.7
- Probability of Profit: ~58%

### Greeks
- Delta: +0.42
- Theta: -0.08 (time decay)
- Vega: +0.15 (IV exposure)

### Management Rules
- Take profit: 50% max gain ($3.65)
- Stop loss: 50% max loss ($1.35)
- Adjust: Roll up if stock breaks $190

### Why This Strategy?
✅ Limited risk, defined reward
✅ Lower cost than buying stock
✅ Benefits from upward movement
✅ Time decay manageable with spread
```

---

## Case 5: Sector Rotation Analysis

**User Request**:
```
"Analyze current sector rotation and suggest positioning"
```

**Output Result**:
```markdown
# Sector Rotation Analysis - March 2026

## Current Market Phase
**Phase**: Mid-Cycle Expansion
- Economic growth: Moderate
- Fed policy: Neutral-to-accommodative
- Inflation: Moderating

## Sector Performance (30-Day)

### Leading Sectors 🚀
1. **Technology** (+8.2%)
   - AI/Cloud momentum
   - Strong earnings
   - Recommendation: Overweight

2. **Communication Services** (+6.5%)
   - Digital ad recovery
   - Streaming growth
   - Recommendation: Overweight

3. **Consumer Discretionary** (+5.1%)
   - Consumer spending resilient
   - E-commerce strong
   - Recommendation: Market weight

### Lagging Sectors 📉
1. **Energy** (-3.2%)
   - Oil price weakness
   - Demand concerns
   - Recommendation: Underweight

2. **Utilities** (-2.1%)
   - Rate sensitivity
   - Defensive rotation out
   - Recommendation: Underweight

3. **Real Estate** (-1.8%)
   - Yield competition
   - Office space concerns
   - Recommendation: Underweight

## Rotation Strategy

### Overweight Positions (60%)
- Technology: 25%
- Communication Services: 20%
- Financials: 15%

### Market Weight (30%)
- Healthcare: 15%
- Consumer Discretionary: 15%

### Underweight (10%)
- Energy: 5%
- Utilities: 3%
- Real Estate: 2%

## Key Catalysts to Watch
- Fed policy signals
- Q1 earnings season
- Economic data (GDP, employment)
- Geopolitical developments

## Tactical Recommendations
1. Add tech on pullbacks to 50-day MA
2. Trim energy on any bounce
3. Hold defensive hedges (5-10% cash)
4. Monitor sector momentum weekly
```
