# Technical Analysis Basics

*Technical analysis studies price/volume to forecast moves. It's not predictive — it's probabilistic.*

## Chart Types

| Type | Shows | Best for |
|------|-------|----------|
| Candlestick | Open, high, low, close | Most trading styles |
| Line | Closing prices only | Long-term trends |
| Bar (OHLC) | Same as candle, different visual | Some prefer for clarity |

**Candlestick anatomy:** Body shows open→close, wicks show high/low. Green/white = closed higher, red/black = closed lower.

## Timeframes

| Timeframe | Used by | Context |
|-----------|---------|---------|
| 1-5 min | Scalpers | Noise-heavy, fast decisions |
| 15-60 min | Day traders | Intraday structure |
| 4H-Daily | Swing traders | Cleaner signals |
| Weekly-Monthly | Position traders | Big picture only |

**Multi-timeframe rule:** Analyze higher timeframe for direction, lower for entries.

## Key Patterns

**Continuation (trend likely continues):**
- Flags/pennants — Brief consolidation after strong move
- Triangles — Compression before breakout

**Reversal (trend may change):**
- Head & shoulders — Three peaks, middle highest
- Double top/bottom — Two tests of same level fail

**Caution:** Patterns fail often. Never trade pattern alone without stop loss.

## Common Indicators

| Indicator | What it shows | Trap |
|-----------|---------------|------|
| Moving averages (MA) | Smoothed price trend | Lags — late signals |
| RSI | Overbought/oversold | Can stay extreme during trends |
| MACD | Momentum + trend | Many false crosses |
| Volume | Trade activity | Interpretation varies |

**Indicator overload:** More indicators ≠ better decisions. Most traders use 2-3 maximum.

## Support & Resistance

- **Support:** Price level where buying has previously emerged
- **Resistance:** Price level where selling has previously emerged
- Levels are zones, not exact numbers
- Broken resistance often becomes support (and vice versa)

## What Technical Analysis Cannot Do

- Predict with certainty (nothing can)
- Account for news events or black swans
- Work in isolation — requires risk management
- Replace a trading plan

## Common Beginner Mistakes

1. Drawing too many lines — charts become unreadable
2. Fitting patterns after the fact (hindsight bias)
3. Ignoring timeframe context
4. Believing indicators are signals (they're inputs, not answers)
