# Setup — Trading

## First-Time Setup

### 1. Acknowledge Disclaimers

Before proceeding, read `legal.md` and acknowledge that:
- This is educational content only
- Nothing constitutes financial advice
- User is responsible for their own decisions
- Consulting licensed professionals is recommended

### 2. Create Memory Structure (Optional)

If user wants to track learning progress:

```bash
mkdir -p ~/trading
```

### 3. Initialize Memory (Optional)

Create `~/trading/memory.md` using the template in `memory-template.md`.

## Configuration

No mandatory configuration required. The skill works from minute zero.

Optional preferences to capture over time:
- Primary market focus (stocks, forex, crypto)
- Current learning stage (demo, small live, scaling)
- Trading style interest (day trading, swing, position)
- Risk tolerance preferences

## Without Setup

Skill works immediately with defaults:
- Assumes beginner level
- Covers all markets equally
- Uses conservative risk examples (1% per trade)
- No progress tracking

## Workspace Integration

If user has a main `AGENTS.md` or `USER.md`, consider adding:

```markdown
## Trading Education

Currently learning: [market] trading
Stage: Demo / Live (small) / Scaling
Focus: [style]
```

This helps the agent tailor content across sessions.
