# Risk Management

*Risk management determines survival. Good entries with bad risk management = eventual ruin.*

## Position Sizing

**The 1-2% rule:** Never risk more than 1-2% of account on a single trade.

**Calculation:**
```
Risk amount = Account × 1%
Position size = Risk amount ÷ (Entry - Stop loss)
```

**Example:** $10,000 account, 1% risk = $100 max loss per trade.
If entry is $50 and stop is $48 (risk $2/share):
Position = $100 ÷ $2 = 50 shares maximum.

## Stop Loss Placement

**Rules:**
- Set stop BEFORE entering trade
- Place based on technical levels, not arbitrary percentages
- Never move stop further from entry (only closer to lock profits)
- Accept that stops will sometimes trigger before reversals

**Stop types:**
- **Hard stop:** Order placed with broker, executes automatically
- **Mental stop:** You commit to exit at price (unreliable — use hard stops)
- **Trailing stop:** Moves with price to lock in gains

## Risk/Reward Ratio

Minimum 1:2 means potential profit is 2× potential loss.

| Win Rate | Required R:R to Break Even |
|----------|---------------------------|
| 50% | 1:1 |
| 40% | 1:1.5 |
| 33% | 1:2 |
| 25% | 1:3 |

**Reality:** Most traders have 40-50% win rates. You NEED favorable R:R to be profitable.

## Drawdown Management

**Drawdown:** Peak-to-trough decline in account value.

| Drawdown | Required Gain to Recover |
|----------|-------------------------|
| 10% | 11% |
| 20% | 25% |
| 30% | 43% |
| 50% | 100% |

**Rules:**
- If down 10% in a day/week, stop trading and review
- Consider reducing position size during drawdowns
- Have a "circuit breaker" — maximum daily/weekly loss before stopping

## Correlation Risk

Five "different" trades in correlated assets = one large bet.

**Examples of hidden correlation:**
- Tech stocks move together
- AUD/USD, NZD/USD, and copper often correlate
- Crypto markets are highly correlated

**Solution:** Limit exposure to correlated positions.

## Leverage

**What leverage does:**
- 10:1 leverage = $1,000 controls $10,000 position
- Gains amplified 10×
- Losses amplified 10× (can exceed deposit)

**Margin call:** Broker forces position closed if losses approach deposit.

| Leverage | Move against you | Your loss |
|----------|-----------------|-----------|
| No leverage | -10% | -10% |
| 5:1 | -10% | -50% |
| 10:1 | -10% | -100% (wiped) |

**Rule:** New traders should use minimal or no leverage until consistently profitable.

## Psychology Integration

- **Pre-trade:** Know exact entry, stop, target before clicking
- **During trade:** Do not stare at screen — you'll intervene badly
- **After loss:** Log it, analyze it, move on. No revenge trades.
- **After win:** Don't increase size immediately. Wins breed overconfidence.
