# Platforms & Regulations

*Broker selection matters. Wrong choice = lost funds, poor execution, or legal issues.*

## Choosing a Broker

**Non-negotiables:**
- Regulated by reputable authority (SEC/FINRA, FCA, ASIC, etc.)
- Segregated client funds
- Transparent fee structure
- Reliable execution (check reviews for outages)

**Important factors:**
- Commission/spread costs
- Available markets
- Platform quality
- Customer support responsiveness
- Withdrawal ease

## Regulatory Bodies

| Region | Authority | Checks |
|--------|-----------|--------|
| US | SEC, FINRA, NFA | brokercheck.finra.org |
| UK | FCA | register.fca.org.uk |
| EU | Varies (CySEC, BaFin, etc.) | National registers |
| Australia | ASIC | asic.gov.au |

**Warning:** Offshore/unregulated brokers may offer better terms but have no investor protection. Many are scams.

## US-Specific Rules

**Pattern Day Trader (PDT):**
- 4+ day trades in 5 business days = PDT classification
- Requires $25,000 minimum equity
- Applies to margin accounts only
- Workarounds: cash account (no margin), offshore broker (risky), multiple accounts

**Wash Sale Rule:**
- Cannot claim tax loss if you buy same/similar security within 30 days
- Affects active traders significantly

## Market-Specific Considerations

**Stocks:**
- Most regulated, most resources available
- Market hours: US 9:30-16:00 ET (pre/post-market available)
- T+2 settlement (cash takes 2 days to clear)

**Forex:**
- 24/5 markets (Sunday evening - Friday evening)
- Less regulated in many jurisdictions
- High leverage commonly offered (dangerous)
- Spreads widen during low liquidity (Asian session for EUR/USD)

**Crypto:**
- 24/7 markets, no breaks
- Regulation varies wildly by country
- Exchange risk: platforms can freeze funds, get hacked, go bankrupt (FTX)
- Consider self-custody for holdings

**Futures/Options:**
- Complex products, require additional approvals
- Can lose more than deposit
- Expiration dates, exercise rules, Greeks (options)

## Fee Types

| Fee | What it is | Watch for |
|-----|------------|-----------|
| Commission | Per-trade charge | $0 common but hidden in spread |
| Spread | Difference bid/ask | Main cost in forex |
| Overnight/swap | Holding cost overnight | Kills swing trades in forex |
| Inactivity fee | Charged if not trading | Read fine print |
| Withdrawal fee | To get your money out | Some brokers punish withdrawals |

## Red Flags

- Promises of guaranteed returns
- Unregulated jurisdiction (St. Vincent, Marshall Islands)
- Bonus structures that lock funds
- Difficulty withdrawing
- Pressure to deposit more
- "Account managers" making trades for you

## Tax Considerations

**General principle:** Trading profits are taxable. Frequent trading often taxed at higher short-term rates.

- Keep records of all trades
- Consider tax software or accountant
- Some jurisdictions allow trader tax status (US Section 475)
- Crypto tax reporting is complex and actively enforced

*Always consult a tax professional for your specific situation.*
